/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.retry;

import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayRetryPolicy;
import java.beans.ConstructorProperties;
import java.util.Random;

public final class DelayPolicyExecutor {
    private final DelayRetryPolicy delayRetryPolicy;
    private final Random random = new Random();
    private int executeCount;
    private long executeTick = System.currentTimeMillis();

    public boolean hasNext() {
        return this.executeCount < this.delayRetryPolicy.getRetryCount();
    }

    public long getNextTick() {
        return this.executeTick;
    }

    public void next() {
        ++this.executeCount;
        long sleep = this.delayRetryPolicy.getBaseDelay() * (long)Math.max(1, this.random.nextInt(1 << this.delayRetryPolicy.getRetryCount() + 1));
        this.executeTick = sleep < this.delayRetryPolicy.getDelayUpperBound() ? (this.executeTick += sleep) : (this.executeTick += this.delayRetryPolicy.getDelayUpperBound());
    }

    @ConstructorProperties(value={"delayRetryPolicy"})
    public DelayPolicyExecutor(DelayRetryPolicy delayRetryPolicy) {
        this.delayRetryPolicy = delayRetryPolicy;
    }
}

