/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.cache;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingsphere.orchestration.reg.newzk.client.action.IClient;
import io.shardingsphere.orchestration.reg.newzk.client.action.IProvider;
import io.shardingsphere.orchestration.reg.newzk.client.cache.PathNode;
import io.shardingsphere.orchestration.reg.newzk.client.cache.PathResolve;
import io.shardingsphere.orchestration.reg.newzk.client.cache.PathStatus;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.ZookeeperEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathTree
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PathTree.class);
    private final IClient client;
    private final IProvider provider;
    private final AtomicReference<PathNode> rootNode = new AtomicReference();
    private final List<String> watcherKeys = new ArrayList<String>();
    private final transient ReentrantLock lock = new ReentrantLock();
    private boolean executorStart;
    private ScheduledExecutorService cacheService;
    private PathStatus status;
    private boolean closed;

    public PathTree(String root, IClient client) {
        this.rootNode.set(new PathNode(root));
        this.status = PathStatus.RELEASE;
        this.client = client;
        this.provider = client.getExecStrategy().getProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws KeeperException, InterruptedException {
        block7: {
            ReentrantLock lock = this.lock;
            lock.lockInterruptibly();
            if (this.closed) {
                return;
            }
            try {
                if (this.status == PathStatus.RELEASE) {
                    this.status = PathStatus.CHANGING;
                    PathNode newRoot = new PathNode(this.rootNode.get().getNodeKey());
                    List<String> children = this.provider.getChildren(PathUtil.checkPath(this.rootNode.get().getNodeKey()));
                    children.remove("CHANGING_KEY");
                    this.attachIntoNode(children, newRoot);
                    this.rootNode.set(newRoot);
                    this.status = PathStatus.RELEASE;
                    break block7;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    log.error("loading sleep error: {}", (Object)ex.getMessage(), (Object)ex);
                }
                this.load();
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void attachIntoNode(List<String> children, PathNode pathNode) throws KeeperException, InterruptedException {
        if (this.closed) {
            return;
        }
        if (children.isEmpty()) {
            return;
        }
        for (String each : children) {
            String childPath = PathUtil.getRealPath(pathNode.getPath(), each);
            PathNode current = new PathNode(each, this.provider.getData(childPath));
            pathNode.attachChild(current);
            List<String> subs = this.provider.getChildren(childPath);
            this.attachIntoNode(subs, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPeriodic(long period) {
        ReentrantLock lock = this.lock;
        lock.lock();
        if (this.closed) {
            return;
        }
        try {
            Preconditions.checkState((!this.executorStart ? 1 : 0) != 0, (Object)"period already set");
            long threadPeriod = period;
            if (threadPeriod < 1L) {
                threadPeriod = 3000L;
            }
            this.cacheService = Executors.newSingleThreadScheduledExecutor();
            this.cacheService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (PathStatus.RELEASE == PathTree.this.getStatus()) {
                        try {
                            PathTree.this.load();
                        }
                        catch (InterruptedException | KeeperException ex) {
                            log.error(ex.getMessage(), ex);
                        }
                    }
                }
            }, 1000L, threadPeriod, TimeUnit.MILLISECONDS);
            this.executorStart = true;
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    PathTree.this.stopRefresh();
                }
            }));
        }
        finally {
            lock.unlock();
        }
    }

    public void stopRefresh() {
        this.cacheService.shutdown();
        this.executorStart = false;
    }

    public void watch() {
        this.watch(new ZookeeperEventListener(this.rootNode.get().getNodeKey()){

            @Override
            public void process(WatchedEvent event) {
                String path = event.getPath();
                switch (event.getType()) {
                    case NodeCreated: 
                    case NodeDataChanged: 
                    case NodeChildrenChanged: {
                        PathTree.this.processNodeChange(path);
                        break;
                    }
                    case NodeDeleted: {
                        PathTree.this.delete(path);
                        break;
                    }
                }
            }
        });
    }

    public void watch(ZookeeperEventListener zookeeperEventListener) {
        if (this.closed) {
            return;
        }
        String key = zookeeperEventListener.getKey();
        this.client.registerWatch(this.rootNode.get().getNodeKey(), zookeeperEventListener);
        this.watcherKeys.add(key);
    }

    private void processNodeChange(String path) {
        try {
            String value = this.provider.getDataString(path);
            this.put(path, value);
        }
        catch (InterruptedException | KeeperException ex) {
            if (ex instanceof KeeperException.NoNodeException || ex instanceof KeeperException.ConnectionLossException) {
                log.debug(ex.getMessage());
                return;
            }
            log.error("PathTree put error : " + ex.getMessage());
        }
    }

    public byte[] getValue(String path) {
        if (this.closed) {
            return null;
        }
        PathNode node = this.get(path);
        return null == node ? null : node.getValue();
    }

    public List<String> getChildren(String path) {
        if (this.closed) {
            return null;
        }
        PathNode node = this.get(path);
        ArrayList<String> result = new ArrayList<String>();
        if (node == null) {
            return result;
        }
        if (node.getChildren().isEmpty()) {
            return result;
        }
        for (PathNode pathNode : node.getChildren().values()) {
            result.add(new String(pathNode.getValue()));
        }
        return result;
    }

    private PathNode get(String path) {
        if (Strings.isNullOrEmpty((String)path) || path.equals("/")) {
            return this.rootNode.get();
        }
        String realPath = this.provider.getRealPath(path);
        PathResolve pathResolve = new PathResolve(realPath);
        pathResolve.next();
        if (pathResolve.isEnd()) {
            return this.rootNode.get();
        }
        return this.rootNode.get().get(pathResolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String path, String value) {
        block7: {
            ReentrantLock lock = this.lock;
            lock.lock();
            if (this.closed) {
                return;
            }
            try {
                if (this.status == PathStatus.RELEASE) {
                    this.setStatus(PathStatus.CHANGING);
                    String realPath = this.provider.getRealPath(path);
                    PathResolve pathResolve = new PathResolve(realPath);
                    pathResolve.next();
                    this.rootNode.get().set(pathResolve, value);
                    this.setStatus(PathStatus.RELEASE);
                    break block7;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    log.error("put sleep error:{}", (Object)ex.getMessage(), (Object)ex);
                }
                this.put(path, value);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path) {
        ReentrantLock lock = this.lock;
        lock.lock();
        if (this.closed) {
            return;
        }
        try {
            if (this.rootNode.get().getChildren().containsKey(path)) {
                this.rootNode.get().getChildren().remove(path);
                return;
            }
            String realPath = this.provider.getRealPath(path);
            PathResolve pathResolve = new PathResolve(realPath);
            pathResolve.next();
            this.rootNode.get().delete(pathResolve);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ReentrantLock lock = this.lock;
        lock.lock();
        this.closed = true;
        try {
            if (this.executorStart) {
                this.stopRefresh();
            }
            this.deleteAllChildren(this.rootNode.get());
            if (!this.watcherKeys.isEmpty()) {
                for (String each : this.watcherKeys) {
                    this.client.unregisterWatch(each);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void deleteAllChildren(PathNode node) {
        if (node.getChildren().isEmpty()) {
            return;
        }
        for (String each : node.getChildren().keySet()) {
            this.deleteAllChildren(node.getChildren().get(each));
            node.getChildren().remove(each);
        }
    }

    public PathStatus getStatus() {
        return this.status;
    }

    public void setStatus(PathStatus status) {
        this.status = status;
    }
}

