/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import io.shardingsphere.orchestration.reg.exception.RegExceptionHandler;
import io.shardingsphere.orchestration.reg.listener.DataChangedEvent;
import io.shardingsphere.orchestration.reg.listener.EventListener;
import io.shardingsphere.orchestration.reg.newzk.client.action.IClient;
import io.shardingsphere.orchestration.reg.newzk.client.cache.PathTree;
import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayRetryPolicy;
import io.shardingsphere.orchestration.reg.newzk.client.utility.ZookeeperConstants;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.ClientFactory;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.StrategyType;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.ZookeeperEventListener;
import io.shardingsphere.orchestration.reg.zookeeper.ZookeeperConfiguration;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.ZooDefs;

public final class NewZookeeperRegistryCenter
implements RegistryCenter {
    private final IClient client;
    private final Map<String, PathTree> caches;

    public NewZookeeperRegistryCenter(ZookeeperConfiguration zkConfig) {
        this.client = this.initClient(this.buildClientFactory(zkConfig), zkConfig);
        this.caches = new HashMap<String, PathTree>();
    }

    private ClientFactory buildClientFactory(ZookeeperConfiguration zkConfig) {
        ClientFactory result = new ClientFactory();
        result.setClientNamespace(zkConfig.getNamespace()).newClient(zkConfig.getServerLists(), zkConfig.getSessionTimeoutMilliseconds()).setRetryPolicy(new DelayRetryPolicy(zkConfig.getBaseSleepTimeMilliseconds(), zkConfig.getMaxRetries(), zkConfig.getMaxSleepTimeMilliseconds()));
        if (!Strings.isNullOrEmpty((String)zkConfig.getDigest())) {
            result.authorization("digest", zkConfig.getDigest().getBytes(Charsets.UTF_8), ZooDefs.Ids.CREATOR_ALL_ACL);
        }
        return result;
    }

    private IClient initClient(ClientFactory clientFactory, ZookeeperConfiguration zkConfig) {
        IClient result = null;
        try {
            result = clientFactory.start();
            if (!result.blockUntilConnected(zkConfig.getMaxSleepTimeMilliseconds() * zkConfig.getMaxRetries(), TimeUnit.MILLISECONDS)) {
                result.close();
                throw new KeeperException.OperationTimeoutException();
            }
            result.useExecStrategy(StrategyType.SYNC_RETRY);
        }
        catch (IOException | InterruptedException | KeeperException.OperationTimeoutException ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
        return result;
    }

    @Override
    public String get(String key) {
        Optional<PathTree> cache = this.findTreeCache(key);
        if (!cache.isPresent()) {
            return this.getDirectly(key);
        }
        byte[] resultInCache = ((PathTree)cache.get()).getValue(key);
        if (null != resultInCache) {
            return new String(resultInCache, Charsets.UTF_8);
        }
        return this.getDirectly(key);
    }

    private Optional<PathTree> findTreeCache(String key) {
        for (Map.Entry<String, PathTree> entry : this.caches.entrySet()) {
            if (!key.startsWith(entry.getKey())) continue;
            return Optional.of((Object)entry.getValue());
        }
        return Optional.absent();
    }

    @Override
    public String getDirectly(String key) {
        try {
            return new String(this.client.getData(key), Charsets.UTF_8);
        }
        catch (InterruptedException | KeeperException ex) {
            RegExceptionHandler.handleException((Exception)ex);
            return null;
        }
    }

    @Override
    public boolean isExisted(String key) {
        try {
            return this.client.checkExists(key);
        }
        catch (InterruptedException | KeeperException ex) {
            RegExceptionHandler.handleException((Exception)ex);
            return false;
        }
    }

    @Override
    public List<String> getChildrenKeys(String key) {
        try {
            List<String> result = this.client.getChildren(key);
            Collections.sort(result, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            return result;
        }
        catch (InterruptedException | KeeperException ex) {
            RegExceptionHandler.handleException((Exception)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                this.client.createAllNeedPath(key, value, CreateMode.PERSISTENT);
            } else {
                this.update(key, value);
            }
        }
        catch (InterruptedException | KeeperException ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    @Override
    public void update(String key, String value) {
        try {
            this.client.transaction().check(key, -1).setData(key, value.getBytes(ZookeeperConstants.UTF_8), -1).commit();
        }
        catch (InterruptedException | KeeperException ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    @Override
    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.deleteAllChildren(key);
            }
            this.client.createAllNeedPath(key, value, CreateMode.EPHEMERAL);
        }
        catch (InterruptedException | KeeperException ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    @Override
    public void watch(String key, final EventListener eventListener) {
        String path = key + "/";
        if (!this.caches.containsKey(path)) {
            this.addCacheData(key);
        }
        PathTree cache = this.caches.get(path);
        cache.watch(new ZookeeperEventListener(){

            @Override
            public void process(WatchedEvent event) {
                if (!Strings.isNullOrEmpty((String)event.getPath())) {
                    eventListener.onChange(new DataChangedEvent(NewZookeeperRegistryCenter.this.extractEventType(event), event.getPath(), NewZookeeperRegistryCenter.this.getWithoutCache(event.getPath())));
                }
            }
        });
    }

    private DataChangedEvent.Type extractEventType(WatchedEvent event) {
        switch (event.getType()) {
            case NodeDataChanged: 
            case NodeChildrenChanged: {
                return DataChangedEvent.Type.UPDATED;
            }
            case NodeDeleted: {
                return DataChangedEvent.Type.DELETED;
            }
        }
        return DataChangedEvent.Type.IGNORED;
    }

    private synchronized String getWithoutCache(String key) {
        try {
            this.client.useExecStrategy(StrategyType.USUAL);
            byte[] data = this.client.getData(key);
            this.client.useExecStrategy(StrategyType.SYNC_RETRY);
            return null == data ? null : new String(data, Charsets.UTF_8);
        }
        catch (InterruptedException | KeeperException ex) {
            RegExceptionHandler.handleException((Exception)ex);
            return null;
        }
    }

    private void addCacheData(String cachePath) {
        PathTree cache = new PathTree(cachePath, this.client);
        try {
            cache.load();
            cache.watch();
        }
        catch (InterruptedException | KeeperException ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
        this.caches.put(cachePath + "/", cache);
    }

    @Override
    public void close() {
        for (Map.Entry<String, PathTree> each : this.caches.entrySet()) {
            each.getValue().close();
        }
        this.client.close();
    }
}

