/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.etcd.internal.retry;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Optional;
import io.shardingsphere.orchestration.reg.etcd.EtcdConfiguration;
import io.shardingsphere.orchestration.reg.exception.RegExceptionHandler;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class EtcdRetryEngine {
    private final EtcdConfiguration etcdConfig;

    public <T> Optional<T> execute(Callable<T> callable) {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(TimeoutException.class).retryIfExceptionOfType(ExecutionException.class).retryIfExceptionOfType(InterruptedException.class).withWaitStrategy(WaitStrategies.fixedWait((long)this.etcdConfig.getRetryIntervalMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)this.etcdConfig.getMaxRetries())).build();
        try {
            return Optional.fromNullable((Object)retryer.call(callable));
        }
        catch (RetryException | ExecutionException ex) {
            RegExceptionHandler.handleException((Exception)ex);
            return Optional.absent();
        }
    }

    @ConstructorProperties(value={"etcdConfig"})
    public EtcdRetryEngine(EtcdConfiguration etcdConfig) {
        this.etcdConfig = etcdConfig;
    }
}

