/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.etcd.internal.channel;

import io.grpc.Channel;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.util.RoundRobinLoadBalancerFactory;
import io.shardingsphere.orchestration.reg.etcd.internal.channel.EtcdNameSolverFactory;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class EtcdChannelFactory {
    private static final String TARGET = "etcd";
    private static ConcurrentHashMap<List<String>, Channel> etcdChannels = new ConcurrentHashMap();

    public static Channel getInstance(List<String> endpoints) {
        if (etcdChannels.containsKey(endpoints)) {
            return etcdChannels.get(endpoints);
        }
        ManagedChannel channel = ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)TARGET).usePlaintext(true).nameResolverFactory((NameResolver.Factory)new EtcdNameSolverFactory(TARGET, endpoints))).loadBalancerFactory((LoadBalancer.Factory)RoundRobinLoadBalancerFactory.getInstance())).build();
        Channel result = etcdChannels.putIfAbsent(endpoints, (Channel)channel);
        return null == result ? channel : result;
    }

    private EtcdChannelFactory() {
    }
}

