/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.etcd;

import com.google.common.base.Optional;
import com.google.protobuf.ByteString;
import etcdserverpb.KVGrpc;
import etcdserverpb.LeaseGrpc;
import etcdserverpb.Rpc;
import etcdserverpb.WatchGrpc;
import io.grpc.Channel;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import io.shardingsphere.orchestration.reg.etcd.EtcdConfiguration;
import io.shardingsphere.orchestration.reg.etcd.internal.channel.EtcdChannelFactory;
import io.shardingsphere.orchestration.reg.etcd.internal.keepalive.KeepAlive;
import io.shardingsphere.orchestration.reg.etcd.internal.retry.EtcdRetryEngine;
import io.shardingsphere.orchestration.reg.etcd.internal.watcher.EtcdWatchStreamObserver;
import io.shardingsphere.orchestration.reg.exception.RegException;
import io.shardingsphere.orchestration.reg.listener.EventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import mvccpb.Kv;

public final class EtcdRegistryCenter
implements RegistryCenter {
    private final EtcdConfiguration etcdConfig;
    private final EtcdRetryEngine etcdRetryEngine;
    private final KVGrpc.KVFutureStub kvStub;
    private final LeaseGrpc.LeaseFutureStub leaseStub;
    private final WatchGrpc.WatchStub watchStub;
    private final KeepAlive keepAlive;

    public EtcdRegistryCenter(EtcdConfiguration etcdConfig) {
        this.etcdConfig = etcdConfig;
        this.etcdRetryEngine = new EtcdRetryEngine(etcdConfig);
        Channel channel = EtcdChannelFactory.getInstance(Arrays.asList(etcdConfig.getServerLists().split(",")));
        this.kvStub = KVGrpc.newFutureStub(channel);
        this.leaseStub = LeaseGrpc.newFutureStub(channel);
        this.watchStub = WatchGrpc.newStub(channel);
        this.keepAlive = new KeepAlive(channel, etcdConfig.getTimeToLiveSeconds());
    }

    @Override
    public String get(String key) {
        final Rpc.RangeRequest request = Rpc.RangeRequest.newBuilder().setKey(ByteString.copyFromUtf8((String)key)).build();
        return (String)this.etcdRetryEngine.execute(new Callable<String>(){

            @Override
            public String call() throws InterruptedException, ExecutionException, TimeoutException {
                Rpc.RangeResponse response = (Rpc.RangeResponse)EtcdRegistryCenter.this.kvStub.range(request).get((long)EtcdRegistryCenter.this.etcdConfig.getTimeoutMilliseconds(), TimeUnit.MILLISECONDS);
                return response.getKvsCount() > 0 ? response.getKvs(0).getValue().toStringUtf8() : null;
            }
        }).orNull();
    }

    @Override
    public String getDirectly(String key) {
        return this.get(key);
    }

    @Override
    public boolean isExisted(String key) {
        return null != this.get(key);
    }

    @Override
    public List<String> getChildrenKeys(String key) {
        String path = key + "/";
        final Rpc.RangeRequest request = Rpc.RangeRequest.newBuilder().setKey(ByteString.copyFromUtf8((String)path)).setRangeEnd(this.getRangeEnd(path)).build();
        Optional<List<String>> result = this.etcdRetryEngine.execute(new Callable<List<String>>(){

            @Override
            public List<String> call() throws InterruptedException, ExecutionException, TimeoutException {
                Rpc.RangeResponse response = (Rpc.RangeResponse)EtcdRegistryCenter.this.kvStub.range(request).get((long)EtcdRegistryCenter.this.etcdConfig.getTimeoutMilliseconds(), TimeUnit.MILLISECONDS);
                ArrayList<String> result = new ArrayList<String>();
                for (Kv.KeyValue each : response.getKvsList()) {
                    String childFullPath = each.getKey().toStringUtf8();
                    result.add(childFullPath.substring(childFullPath.lastIndexOf("/") + 1));
                }
                return result;
            }
        });
        return result.isPresent() ? (List)result.get() : Collections.emptyList();
    }

    @Override
    public void persist(String key, String value) {
        final Rpc.PutRequest request = Rpc.PutRequest.newBuilder().setPrevKv(true).setKey(ByteString.copyFromUtf8((String)key)).setValue(ByteString.copyFromUtf8((String)value)).build();
        this.etcdRetryEngine.execute(new Callable<Void>(){

            @Override
            public Void call() throws InterruptedException, ExecutionException, TimeoutException {
                EtcdRegistryCenter.this.kvStub.put(request).get((long)EtcdRegistryCenter.this.etcdConfig.getTimeoutMilliseconds(), TimeUnit.MILLISECONDS);
                return null;
            }
        });
    }

    @Override
    public void update(String key, String value) {
        this.persist(key, value);
    }

    @Override
    public void persistEphemeral(String key, String value) {
        Optional<Long> leaseId = this.lease();
        if (!leaseId.isPresent()) {
            throw new RegException("Unable to set up heat beat for key %s", key);
        }
        final Rpc.PutRequest request = Rpc.PutRequest.newBuilder().setPrevKv(true).setLease((Long)leaseId.get()).setKey(ByteString.copyFromUtf8((String)key)).setValue(ByteString.copyFromUtf8((String)value)).build();
        this.etcdRetryEngine.execute(new Callable<Void>(){

            @Override
            public Void call() throws InterruptedException, ExecutionException, TimeoutException {
                EtcdRegistryCenter.this.kvStub.put(request).get((long)EtcdRegistryCenter.this.etcdConfig.getTimeoutMilliseconds(), TimeUnit.MILLISECONDS);
                return null;
            }
        });
    }

    private Optional<Long> lease() {
        final Rpc.LeaseGrantRequest request = Rpc.LeaseGrantRequest.newBuilder().setTTL(this.etcdConfig.getTimeToLiveSeconds()).build();
        return this.etcdRetryEngine.execute(new Callable<Long>(){

            @Override
            public Long call() throws InterruptedException, ExecutionException, TimeoutException {
                long leaseId = ((Rpc.LeaseGrantResponse)EtcdRegistryCenter.this.leaseStub.leaseGrant(request).get((long)EtcdRegistryCenter.this.etcdConfig.getTimeoutMilliseconds(), TimeUnit.MILLISECONDS)).getID();
                EtcdRegistryCenter.this.keepAlive.heartbeat(leaseId);
                return leaseId;
            }
        });
    }

    @Override
    public void watch(String key, final EventListener eventListener) {
        Rpc.WatchCreateRequest createWatchRequest = Rpc.WatchCreateRequest.newBuilder().setKey(ByteString.copyFromUtf8((String)key)).setRangeEnd(this.getRangeEnd(key)).build();
        final Rpc.WatchRequest request = Rpc.WatchRequest.newBuilder().setCreateRequest(createWatchRequest).build();
        this.etcdRetryEngine.execute(new Callable<Void>(){

            @Override
            public Void call() {
                EtcdRegistryCenter.this.watchStub.watch(new EtcdWatchStreamObserver(eventListener)).onNext((Object)request);
                return null;
            }
        });
    }

    @Override
    public void close() {
        this.keepAlive.close();
    }

    private ByteString getRangeEnd(String key) {
        byte[] noPrefix = new byte[]{0};
        byte[] endKey = (byte[])key.getBytes().clone();
        for (int i = endKey.length - 1; i >= 0; --i) {
            if (endKey[i] >= 255) continue;
            endKey[i] = (byte)(endKey[i] + 1);
            return ByteString.copyFrom((byte[])Arrays.copyOf(endKey, i + 1));
        }
        return ByteString.copyFrom((byte[])noPrefix);
    }
}

