package etcdserverpb;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.7.0)",
    comments = "Source: etcd/etcdserver/etcdserverpb/rpc.proto")
public final class KVGrpc {

  private KVGrpc() {}

  public static final String SERVICE_NAME = "etcdserverpb.KV";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.RangeRequest,
      etcdserverpb.Rpc.RangeResponse> METHOD_RANGE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.RangeRequest, etcdserverpb.Rpc.RangeResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.KV", "Range"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.RangeRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.RangeResponse.getDefaultInstance()))
          .setSchemaDescriptor(new KVMethodDescriptorSupplier("Range"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.PutRequest,
      etcdserverpb.Rpc.PutResponse> METHOD_PUT =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.PutRequest, etcdserverpb.Rpc.PutResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.KV", "Put"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.PutRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.PutResponse.getDefaultInstance()))
          .setSchemaDescriptor(new KVMethodDescriptorSupplier("Put"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.DeleteRangeRequest,
      etcdserverpb.Rpc.DeleteRangeResponse> METHOD_DELETE_RANGE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.DeleteRangeRequest, etcdserverpb.Rpc.DeleteRangeResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.KV", "DeleteRange"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.DeleteRangeRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.DeleteRangeResponse.getDefaultInstance()))
          .setSchemaDescriptor(new KVMethodDescriptorSupplier("DeleteRange"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.TxnRequest,
      etcdserverpb.Rpc.TxnResponse> METHOD_TXN =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.TxnRequest, etcdserverpb.Rpc.TxnResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.KV", "Txn"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.TxnRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.TxnResponse.getDefaultInstance()))
          .setSchemaDescriptor(new KVMethodDescriptorSupplier("Txn"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.CompactionRequest,
      etcdserverpb.Rpc.CompactionResponse> METHOD_COMPACT =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.CompactionRequest, etcdserverpb.Rpc.CompactionResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.KV", "Compact"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.CompactionRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.CompactionResponse.getDefaultInstance()))
          .setSchemaDescriptor(new KVMethodDescriptorSupplier("Compact"))
          .build();

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static KVStub newStub(io.grpc.Channel channel) {
    return new KVStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static KVBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new KVBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static KVFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new KVFutureStub(channel);
  }

  /**
   */
  public static abstract class KVImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Range gets the keys in the range from the key-value store.
     * </pre>
     */
    public void range(etcdserverpb.Rpc.RangeRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.RangeResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_RANGE, responseObserver);
    }

    /**
     * <pre>
     * Put puts the given key into the key-value store.
     * A put request increments the revision of the key-value store
     * and generates one event in the event history.
     * </pre>
     */
    public void put(etcdserverpb.Rpc.PutRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.PutResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_PUT, responseObserver);
    }

    /**
     * <pre>
     * DeleteRange deletes the given range from the key-value store.
     * A delete request increments the revision of the key-value store
     * and generates a delete event in the event history for every deleted key.
     * </pre>
     */
    public void deleteRange(etcdserverpb.Rpc.DeleteRangeRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.DeleteRangeResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_DELETE_RANGE, responseObserver);
    }

    /**
     * <pre>
     * Txn processes multiple requests in a single transaction.
     * A txn request increments the revision of the key-value store
     * and generates events with the same revision for every completed request.
     * It is not allowed to modify the same key several times within one txn.
     * </pre>
     */
    public void txn(etcdserverpb.Rpc.TxnRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.TxnResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_TXN, responseObserver);
    }

    /**
     * <pre>
     * Compact compacts the event history in the etcd key-value store. The key-value
     * store should be periodically compacted or the event history will continue to grow
     * indefinitely.
     * </pre>
     */
    public void compact(etcdserverpb.Rpc.CompactionRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.CompactionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_COMPACT, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_RANGE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.RangeRequest,
                etcdserverpb.Rpc.RangeResponse>(
                  this, METHODID_RANGE)))
          .addMethod(
            METHOD_PUT,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.PutRequest,
                etcdserverpb.Rpc.PutResponse>(
                  this, METHODID_PUT)))
          .addMethod(
            METHOD_DELETE_RANGE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.DeleteRangeRequest,
                etcdserverpb.Rpc.DeleteRangeResponse>(
                  this, METHODID_DELETE_RANGE)))
          .addMethod(
            METHOD_TXN,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.TxnRequest,
                etcdserverpb.Rpc.TxnResponse>(
                  this, METHODID_TXN)))
          .addMethod(
            METHOD_COMPACT,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.CompactionRequest,
                etcdserverpb.Rpc.CompactionResponse>(
                  this, METHODID_COMPACT)))
          .build();
    }
  }

  /**
   */
  public static final class KVStub extends io.grpc.stub.AbstractStub<KVStub> {
    private KVStub(io.grpc.Channel channel) {
      super(channel);
    }

    private KVStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected KVStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new KVStub(channel, callOptions);
    }

    /**
     * <pre>
     * Range gets the keys in the range from the key-value store.
     * </pre>
     */
    public void range(etcdserverpb.Rpc.RangeRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.RangeResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_RANGE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Put puts the given key into the key-value store.
     * A put request increments the revision of the key-value store
     * and generates one event in the event history.
     * </pre>
     */
    public void put(etcdserverpb.Rpc.PutRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.PutResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_PUT, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * DeleteRange deletes the given range from the key-value store.
     * A delete request increments the revision of the key-value store
     * and generates a delete event in the event history for every deleted key.
     * </pre>
     */
    public void deleteRange(etcdserverpb.Rpc.DeleteRangeRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.DeleteRangeResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_DELETE_RANGE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Txn processes multiple requests in a single transaction.
     * A txn request increments the revision of the key-value store
     * and generates events with the same revision for every completed request.
     * It is not allowed to modify the same key several times within one txn.
     * </pre>
     */
    public void txn(etcdserverpb.Rpc.TxnRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.TxnResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_TXN, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Compact compacts the event history in the etcd key-value store. The key-value
     * store should be periodically compacted or the event history will continue to grow
     * indefinitely.
     * </pre>
     */
    public void compact(etcdserverpb.Rpc.CompactionRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.CompactionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_COMPACT, getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class KVBlockingStub extends io.grpc.stub.AbstractStub<KVBlockingStub> {
    private KVBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private KVBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected KVBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new KVBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Range gets the keys in the range from the key-value store.
     * </pre>
     */
    public etcdserverpb.Rpc.RangeResponse range(etcdserverpb.Rpc.RangeRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_RANGE, getCallOptions(), request);
    }

    /**
     * <pre>
     * Put puts the given key into the key-value store.
     * A put request increments the revision of the key-value store
     * and generates one event in the event history.
     * </pre>
     */
    public etcdserverpb.Rpc.PutResponse put(etcdserverpb.Rpc.PutRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_PUT, getCallOptions(), request);
    }

    /**
     * <pre>
     * DeleteRange deletes the given range from the key-value store.
     * A delete request increments the revision of the key-value store
     * and generates a delete event in the event history for every deleted key.
     * </pre>
     */
    public etcdserverpb.Rpc.DeleteRangeResponse deleteRange(etcdserverpb.Rpc.DeleteRangeRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_DELETE_RANGE, getCallOptions(), request);
    }

    /**
     * <pre>
     * Txn processes multiple requests in a single transaction.
     * A txn request increments the revision of the key-value store
     * and generates events with the same revision for every completed request.
     * It is not allowed to modify the same key several times within one txn.
     * </pre>
     */
    public etcdserverpb.Rpc.TxnResponse txn(etcdserverpb.Rpc.TxnRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_TXN, getCallOptions(), request);
    }

    /**
     * <pre>
     * Compact compacts the event history in the etcd key-value store. The key-value
     * store should be periodically compacted or the event history will continue to grow
     * indefinitely.
     * </pre>
     */
    public etcdserverpb.Rpc.CompactionResponse compact(etcdserverpb.Rpc.CompactionRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_COMPACT, getCallOptions(), request);
    }
  }

  /**
   */
  public static final class KVFutureStub extends io.grpc.stub.AbstractStub<KVFutureStub> {
    private KVFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private KVFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected KVFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new KVFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Range gets the keys in the range from the key-value store.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.RangeResponse> range(
        etcdserverpb.Rpc.RangeRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_RANGE, getCallOptions()), request);
    }

    /**
     * <pre>
     * Put puts the given key into the key-value store.
     * A put request increments the revision of the key-value store
     * and generates one event in the event history.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.PutResponse> put(
        etcdserverpb.Rpc.PutRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_PUT, getCallOptions()), request);
    }

    /**
     * <pre>
     * DeleteRange deletes the given range from the key-value store.
     * A delete request increments the revision of the key-value store
     * and generates a delete event in the event history for every deleted key.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.DeleteRangeResponse> deleteRange(
        etcdserverpb.Rpc.DeleteRangeRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_DELETE_RANGE, getCallOptions()), request);
    }

    /**
     * <pre>
     * Txn processes multiple requests in a single transaction.
     * A txn request increments the revision of the key-value store
     * and generates events with the same revision for every completed request.
     * It is not allowed to modify the same key several times within one txn.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.TxnResponse> txn(
        etcdserverpb.Rpc.TxnRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_TXN, getCallOptions()), request);
    }

    /**
     * <pre>
     * Compact compacts the event history in the etcd key-value store. The key-value
     * store should be periodically compacted or the event history will continue to grow
     * indefinitely.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.CompactionResponse> compact(
        etcdserverpb.Rpc.CompactionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_COMPACT, getCallOptions()), request);
    }
  }

  private static final int METHODID_RANGE = 0;
  private static final int METHODID_PUT = 1;
  private static final int METHODID_DELETE_RANGE = 2;
  private static final int METHODID_TXN = 3;
  private static final int METHODID_COMPACT = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final KVImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(KVImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_RANGE:
          serviceImpl.range((etcdserverpb.Rpc.RangeRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.RangeResponse>) responseObserver);
          break;
        case METHODID_PUT:
          serviceImpl.put((etcdserverpb.Rpc.PutRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.PutResponse>) responseObserver);
          break;
        case METHODID_DELETE_RANGE:
          serviceImpl.deleteRange((etcdserverpb.Rpc.DeleteRangeRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.DeleteRangeResponse>) responseObserver);
          break;
        case METHODID_TXN:
          serviceImpl.txn((etcdserverpb.Rpc.TxnRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.TxnResponse>) responseObserver);
          break;
        case METHODID_COMPACT:
          serviceImpl.compact((etcdserverpb.Rpc.CompactionRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.CompactionResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class KVBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    KVBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return etcdserverpb.Rpc.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("KV");
    }
  }

  private static final class KVFileDescriptorSupplier
      extends KVBaseDescriptorSupplier {
    KVFileDescriptorSupplier() {}
  }

  private static final class KVMethodDescriptorSupplier
      extends KVBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    KVMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (KVGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new KVFileDescriptorSupplier())
              .addMethod(METHOD_RANGE)
              .addMethod(METHOD_PUT)
              .addMethod(METHOD_DELETE_RANGE)
              .addMethod(METHOD_TXN)
              .addMethod(METHOD_COMPACT)
              .build();
        }
      }
    }
    return result;
  }
}
