package etcdserverpb;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.7.0)",
    comments = "Source: etcd/etcdserver/etcdserverpb/rpc.proto")
public final class AuthGrpc {

  private AuthGrpc() {}

  public static final String SERVICE_NAME = "etcdserverpb.Auth";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthEnableRequest,
      etcdserverpb.Rpc.AuthEnableResponse> METHOD_AUTH_ENABLE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthEnableRequest, etcdserverpb.Rpc.AuthEnableResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "AuthEnable"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthEnableRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthEnableResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("AuthEnable"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthDisableRequest,
      etcdserverpb.Rpc.AuthDisableResponse> METHOD_AUTH_DISABLE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthDisableRequest, etcdserverpb.Rpc.AuthDisableResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "AuthDisable"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthDisableRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthDisableResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("AuthDisable"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthenticateRequest,
      etcdserverpb.Rpc.AuthenticateResponse> METHOD_AUTHENTICATE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthenticateRequest, etcdserverpb.Rpc.AuthenticateResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "Authenticate"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthenticateRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthenticateResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("Authenticate"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthUserAddRequest,
      etcdserverpb.Rpc.AuthUserAddResponse> METHOD_USER_ADD =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthUserAddRequest, etcdserverpb.Rpc.AuthUserAddResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "UserAdd"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserAddRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserAddResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserAdd"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthUserGetRequest,
      etcdserverpb.Rpc.AuthUserGetResponse> METHOD_USER_GET =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthUserGetRequest, etcdserverpb.Rpc.AuthUserGetResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "UserGet"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserGetRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserGetResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserGet"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthUserListRequest,
      etcdserverpb.Rpc.AuthUserListResponse> METHOD_USER_LIST =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthUserListRequest, etcdserverpb.Rpc.AuthUserListResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "UserList"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserListRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserListResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserList"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthUserDeleteRequest,
      etcdserverpb.Rpc.AuthUserDeleteResponse> METHOD_USER_DELETE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthUserDeleteRequest, etcdserverpb.Rpc.AuthUserDeleteResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "UserDelete"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserDeleteRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserDeleteResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserDelete"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthUserChangePasswordRequest,
      etcdserverpb.Rpc.AuthUserChangePasswordResponse> METHOD_USER_CHANGE_PASSWORD =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthUserChangePasswordRequest, etcdserverpb.Rpc.AuthUserChangePasswordResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "UserChangePassword"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserChangePasswordRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserChangePasswordResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserChangePassword"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthUserGrantRoleRequest,
      etcdserverpb.Rpc.AuthUserGrantRoleResponse> METHOD_USER_GRANT_ROLE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthUserGrantRoleRequest, etcdserverpb.Rpc.AuthUserGrantRoleResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "UserGrantRole"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserGrantRoleRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserGrantRoleResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserGrantRole"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthUserRevokeRoleRequest,
      etcdserverpb.Rpc.AuthUserRevokeRoleResponse> METHOD_USER_REVOKE_ROLE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthUserRevokeRoleRequest, etcdserverpb.Rpc.AuthUserRevokeRoleResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "UserRevokeRole"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserRevokeRoleRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthUserRevokeRoleResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("UserRevokeRole"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthRoleAddRequest,
      etcdserverpb.Rpc.AuthRoleAddResponse> METHOD_ROLE_ADD =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthRoleAddRequest, etcdserverpb.Rpc.AuthRoleAddResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "RoleAdd"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleAddRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleAddResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleAdd"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthRoleGetRequest,
      etcdserverpb.Rpc.AuthRoleGetResponse> METHOD_ROLE_GET =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthRoleGetRequest, etcdserverpb.Rpc.AuthRoleGetResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "RoleGet"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleGetRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleGetResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleGet"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthRoleListRequest,
      etcdserverpb.Rpc.AuthRoleListResponse> METHOD_ROLE_LIST =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthRoleListRequest, etcdserverpb.Rpc.AuthRoleListResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "RoleList"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleListRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleListResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleList"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthRoleDeleteRequest,
      etcdserverpb.Rpc.AuthRoleDeleteResponse> METHOD_ROLE_DELETE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthRoleDeleteRequest, etcdserverpb.Rpc.AuthRoleDeleteResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "RoleDelete"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleDeleteRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleDeleteResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleDelete"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthRoleGrantPermissionRequest,
      etcdserverpb.Rpc.AuthRoleGrantPermissionResponse> METHOD_ROLE_GRANT_PERMISSION =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthRoleGrantPermissionRequest, etcdserverpb.Rpc.AuthRoleGrantPermissionResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "RoleGrantPermission"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleGrantPermissionRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleGrantPermissionResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleGrantPermission"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.AuthRoleRevokePermissionRequest,
      etcdserverpb.Rpc.AuthRoleRevokePermissionResponse> METHOD_ROLE_REVOKE_PERMISSION =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.AuthRoleRevokePermissionRequest, etcdserverpb.Rpc.AuthRoleRevokePermissionResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Auth", "RoleRevokePermission"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleRevokePermissionRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.AuthRoleRevokePermissionResponse.getDefaultInstance()))
          .setSchemaDescriptor(new AuthMethodDescriptorSupplier("RoleRevokePermission"))
          .build();

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static AuthStub newStub(io.grpc.Channel channel) {
    return new AuthStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static AuthBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new AuthBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static AuthFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new AuthFutureStub(channel);
  }

  /**
   */
  public static abstract class AuthImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * AuthEnable enables authentication.
     * </pre>
     */
    public void authEnable(etcdserverpb.Rpc.AuthEnableRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthEnableResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_AUTH_ENABLE, responseObserver);
    }

    /**
     * <pre>
     * AuthDisable disables authentication.
     * </pre>
     */
    public void authDisable(etcdserverpb.Rpc.AuthDisableRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthDisableResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_AUTH_DISABLE, responseObserver);
    }

    /**
     * <pre>
     * Authenticate processes an authenticate request.
     * </pre>
     */
    public void authenticate(etcdserverpb.Rpc.AuthenticateRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthenticateResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_AUTHENTICATE, responseObserver);
    }

    /**
     * <pre>
     * UserAdd adds a new user.
     * </pre>
     */
    public void userAdd(etcdserverpb.Rpc.AuthUserAddRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserAddResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_USER_ADD, responseObserver);
    }

    /**
     * <pre>
     * UserGet gets detailed user information.
     * </pre>
     */
    public void userGet(etcdserverpb.Rpc.AuthUserGetRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserGetResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_USER_GET, responseObserver);
    }

    /**
     * <pre>
     * UserList gets a list of all users.
     * </pre>
     */
    public void userList(etcdserverpb.Rpc.AuthUserListRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserListResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_USER_LIST, responseObserver);
    }

    /**
     * <pre>
     * UserDelete deletes a specified user.
     * </pre>
     */
    public void userDelete(etcdserverpb.Rpc.AuthUserDeleteRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserDeleteResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_USER_DELETE, responseObserver);
    }

    /**
     * <pre>
     * UserChangePassword changes the password of a specified user.
     * </pre>
     */
    public void userChangePassword(etcdserverpb.Rpc.AuthUserChangePasswordRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserChangePasswordResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_USER_CHANGE_PASSWORD, responseObserver);
    }

    /**
     * <pre>
     * UserGrant grants a role to a specified user.
     * </pre>
     */
    public void userGrantRole(etcdserverpb.Rpc.AuthUserGrantRoleRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserGrantRoleResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_USER_GRANT_ROLE, responseObserver);
    }

    /**
     * <pre>
     * UserRevokeRole revokes a role of specified user.
     * </pre>
     */
    public void userRevokeRole(etcdserverpb.Rpc.AuthUserRevokeRoleRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserRevokeRoleResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_USER_REVOKE_ROLE, responseObserver);
    }

    /**
     * <pre>
     * RoleAdd adds a new role.
     * </pre>
     */
    public void roleAdd(etcdserverpb.Rpc.AuthRoleAddRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleAddResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_ROLE_ADD, responseObserver);
    }

    /**
     * <pre>
     * RoleGet gets detailed role information.
     * </pre>
     */
    public void roleGet(etcdserverpb.Rpc.AuthRoleGetRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleGetResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_ROLE_GET, responseObserver);
    }

    /**
     * <pre>
     * RoleList gets lists of all roles.
     * </pre>
     */
    public void roleList(etcdserverpb.Rpc.AuthRoleListRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleListResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_ROLE_LIST, responseObserver);
    }

    /**
     * <pre>
     * RoleDelete deletes a specified role.
     * </pre>
     */
    public void roleDelete(etcdserverpb.Rpc.AuthRoleDeleteRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleDeleteResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_ROLE_DELETE, responseObserver);
    }

    /**
     * <pre>
     * RoleGrantPermission grants a permission of a specified key or range to a specified role.
     * </pre>
     */
    public void roleGrantPermission(etcdserverpb.Rpc.AuthRoleGrantPermissionRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleGrantPermissionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_ROLE_GRANT_PERMISSION, responseObserver);
    }

    /**
     * <pre>
     * RoleRevokePermission revokes a key or range permission of a specified role.
     * </pre>
     */
    public void roleRevokePermission(etcdserverpb.Rpc.AuthRoleRevokePermissionRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleRevokePermissionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_ROLE_REVOKE_PERMISSION, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_AUTH_ENABLE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthEnableRequest,
                etcdserverpb.Rpc.AuthEnableResponse>(
                  this, METHODID_AUTH_ENABLE)))
          .addMethod(
            METHOD_AUTH_DISABLE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthDisableRequest,
                etcdserverpb.Rpc.AuthDisableResponse>(
                  this, METHODID_AUTH_DISABLE)))
          .addMethod(
            METHOD_AUTHENTICATE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthenticateRequest,
                etcdserverpb.Rpc.AuthenticateResponse>(
                  this, METHODID_AUTHENTICATE)))
          .addMethod(
            METHOD_USER_ADD,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthUserAddRequest,
                etcdserverpb.Rpc.AuthUserAddResponse>(
                  this, METHODID_USER_ADD)))
          .addMethod(
            METHOD_USER_GET,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthUserGetRequest,
                etcdserverpb.Rpc.AuthUserGetResponse>(
                  this, METHODID_USER_GET)))
          .addMethod(
            METHOD_USER_LIST,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthUserListRequest,
                etcdserverpb.Rpc.AuthUserListResponse>(
                  this, METHODID_USER_LIST)))
          .addMethod(
            METHOD_USER_DELETE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthUserDeleteRequest,
                etcdserverpb.Rpc.AuthUserDeleteResponse>(
                  this, METHODID_USER_DELETE)))
          .addMethod(
            METHOD_USER_CHANGE_PASSWORD,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthUserChangePasswordRequest,
                etcdserverpb.Rpc.AuthUserChangePasswordResponse>(
                  this, METHODID_USER_CHANGE_PASSWORD)))
          .addMethod(
            METHOD_USER_GRANT_ROLE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthUserGrantRoleRequest,
                etcdserverpb.Rpc.AuthUserGrantRoleResponse>(
                  this, METHODID_USER_GRANT_ROLE)))
          .addMethod(
            METHOD_USER_REVOKE_ROLE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthUserRevokeRoleRequest,
                etcdserverpb.Rpc.AuthUserRevokeRoleResponse>(
                  this, METHODID_USER_REVOKE_ROLE)))
          .addMethod(
            METHOD_ROLE_ADD,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthRoleAddRequest,
                etcdserverpb.Rpc.AuthRoleAddResponse>(
                  this, METHODID_ROLE_ADD)))
          .addMethod(
            METHOD_ROLE_GET,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthRoleGetRequest,
                etcdserverpb.Rpc.AuthRoleGetResponse>(
                  this, METHODID_ROLE_GET)))
          .addMethod(
            METHOD_ROLE_LIST,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthRoleListRequest,
                etcdserverpb.Rpc.AuthRoleListResponse>(
                  this, METHODID_ROLE_LIST)))
          .addMethod(
            METHOD_ROLE_DELETE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthRoleDeleteRequest,
                etcdserverpb.Rpc.AuthRoleDeleteResponse>(
                  this, METHODID_ROLE_DELETE)))
          .addMethod(
            METHOD_ROLE_GRANT_PERMISSION,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthRoleGrantPermissionRequest,
                etcdserverpb.Rpc.AuthRoleGrantPermissionResponse>(
                  this, METHODID_ROLE_GRANT_PERMISSION)))
          .addMethod(
            METHOD_ROLE_REVOKE_PERMISSION,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.AuthRoleRevokePermissionRequest,
                etcdserverpb.Rpc.AuthRoleRevokePermissionResponse>(
                  this, METHODID_ROLE_REVOKE_PERMISSION)))
          .build();
    }
  }

  /**
   */
  public static final class AuthStub extends io.grpc.stub.AbstractStub<AuthStub> {
    private AuthStub(io.grpc.Channel channel) {
      super(channel);
    }

    private AuthStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AuthStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new AuthStub(channel, callOptions);
    }

    /**
     * <pre>
     * AuthEnable enables authentication.
     * </pre>
     */
    public void authEnable(etcdserverpb.Rpc.AuthEnableRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthEnableResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_AUTH_ENABLE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * AuthDisable disables authentication.
     * </pre>
     */
    public void authDisable(etcdserverpb.Rpc.AuthDisableRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthDisableResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_AUTH_DISABLE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Authenticate processes an authenticate request.
     * </pre>
     */
    public void authenticate(etcdserverpb.Rpc.AuthenticateRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthenticateResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_AUTHENTICATE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserAdd adds a new user.
     * </pre>
     */
    public void userAdd(etcdserverpb.Rpc.AuthUserAddRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserAddResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_USER_ADD, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserGet gets detailed user information.
     * </pre>
     */
    public void userGet(etcdserverpb.Rpc.AuthUserGetRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserGetResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_USER_GET, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserList gets a list of all users.
     * </pre>
     */
    public void userList(etcdserverpb.Rpc.AuthUserListRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserListResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_USER_LIST, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserDelete deletes a specified user.
     * </pre>
     */
    public void userDelete(etcdserverpb.Rpc.AuthUserDeleteRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserDeleteResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_USER_DELETE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserChangePassword changes the password of a specified user.
     * </pre>
     */
    public void userChangePassword(etcdserverpb.Rpc.AuthUserChangePasswordRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserChangePasswordResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_USER_CHANGE_PASSWORD, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserGrant grants a role to a specified user.
     * </pre>
     */
    public void userGrantRole(etcdserverpb.Rpc.AuthUserGrantRoleRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserGrantRoleResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_USER_GRANT_ROLE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UserRevokeRole revokes a role of specified user.
     * </pre>
     */
    public void userRevokeRole(etcdserverpb.Rpc.AuthUserRevokeRoleRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserRevokeRoleResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_USER_REVOKE_ROLE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleAdd adds a new role.
     * </pre>
     */
    public void roleAdd(etcdserverpb.Rpc.AuthRoleAddRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleAddResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_ROLE_ADD, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleGet gets detailed role information.
     * </pre>
     */
    public void roleGet(etcdserverpb.Rpc.AuthRoleGetRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleGetResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_ROLE_GET, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleList gets lists of all roles.
     * </pre>
     */
    public void roleList(etcdserverpb.Rpc.AuthRoleListRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleListResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_ROLE_LIST, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleDelete deletes a specified role.
     * </pre>
     */
    public void roleDelete(etcdserverpb.Rpc.AuthRoleDeleteRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleDeleteResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_ROLE_DELETE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleGrantPermission grants a permission of a specified key or range to a specified role.
     * </pre>
     */
    public void roleGrantPermission(etcdserverpb.Rpc.AuthRoleGrantPermissionRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleGrantPermissionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_ROLE_GRANT_PERMISSION, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RoleRevokePermission revokes a key or range permission of a specified role.
     * </pre>
     */
    public void roleRevokePermission(etcdserverpb.Rpc.AuthRoleRevokePermissionRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleRevokePermissionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_ROLE_REVOKE_PERMISSION, getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class AuthBlockingStub extends io.grpc.stub.AbstractStub<AuthBlockingStub> {
    private AuthBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private AuthBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AuthBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new AuthBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * AuthEnable enables authentication.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthEnableResponse authEnable(etcdserverpb.Rpc.AuthEnableRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_AUTH_ENABLE, getCallOptions(), request);
    }

    /**
     * <pre>
     * AuthDisable disables authentication.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthDisableResponse authDisable(etcdserverpb.Rpc.AuthDisableRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_AUTH_DISABLE, getCallOptions(), request);
    }

    /**
     * <pre>
     * Authenticate processes an authenticate request.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthenticateResponse authenticate(etcdserverpb.Rpc.AuthenticateRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_AUTHENTICATE, getCallOptions(), request);
    }

    /**
     * <pre>
     * UserAdd adds a new user.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthUserAddResponse userAdd(etcdserverpb.Rpc.AuthUserAddRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_USER_ADD, getCallOptions(), request);
    }

    /**
     * <pre>
     * UserGet gets detailed user information.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthUserGetResponse userGet(etcdserverpb.Rpc.AuthUserGetRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_USER_GET, getCallOptions(), request);
    }

    /**
     * <pre>
     * UserList gets a list of all users.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthUserListResponse userList(etcdserverpb.Rpc.AuthUserListRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_USER_LIST, getCallOptions(), request);
    }

    /**
     * <pre>
     * UserDelete deletes a specified user.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthUserDeleteResponse userDelete(etcdserverpb.Rpc.AuthUserDeleteRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_USER_DELETE, getCallOptions(), request);
    }

    /**
     * <pre>
     * UserChangePassword changes the password of a specified user.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthUserChangePasswordResponse userChangePassword(etcdserverpb.Rpc.AuthUserChangePasswordRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_USER_CHANGE_PASSWORD, getCallOptions(), request);
    }

    /**
     * <pre>
     * UserGrant grants a role to a specified user.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthUserGrantRoleResponse userGrantRole(etcdserverpb.Rpc.AuthUserGrantRoleRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_USER_GRANT_ROLE, getCallOptions(), request);
    }

    /**
     * <pre>
     * UserRevokeRole revokes a role of specified user.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthUserRevokeRoleResponse userRevokeRole(etcdserverpb.Rpc.AuthUserRevokeRoleRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_USER_REVOKE_ROLE, getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleAdd adds a new role.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthRoleAddResponse roleAdd(etcdserverpb.Rpc.AuthRoleAddRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_ROLE_ADD, getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleGet gets detailed role information.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthRoleGetResponse roleGet(etcdserverpb.Rpc.AuthRoleGetRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_ROLE_GET, getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleList gets lists of all roles.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthRoleListResponse roleList(etcdserverpb.Rpc.AuthRoleListRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_ROLE_LIST, getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleDelete deletes a specified role.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthRoleDeleteResponse roleDelete(etcdserverpb.Rpc.AuthRoleDeleteRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_ROLE_DELETE, getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleGrantPermission grants a permission of a specified key or range to a specified role.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthRoleGrantPermissionResponse roleGrantPermission(etcdserverpb.Rpc.AuthRoleGrantPermissionRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_ROLE_GRANT_PERMISSION, getCallOptions(), request);
    }

    /**
     * <pre>
     * RoleRevokePermission revokes a key or range permission of a specified role.
     * </pre>
     */
    public etcdserverpb.Rpc.AuthRoleRevokePermissionResponse roleRevokePermission(etcdserverpb.Rpc.AuthRoleRevokePermissionRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_ROLE_REVOKE_PERMISSION, getCallOptions(), request);
    }
  }

  /**
   */
  public static final class AuthFutureStub extends io.grpc.stub.AbstractStub<AuthFutureStub> {
    private AuthFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private AuthFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AuthFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new AuthFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * AuthEnable enables authentication.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthEnableResponse> authEnable(
        etcdserverpb.Rpc.AuthEnableRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_AUTH_ENABLE, getCallOptions()), request);
    }

    /**
     * <pre>
     * AuthDisable disables authentication.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthDisableResponse> authDisable(
        etcdserverpb.Rpc.AuthDisableRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_AUTH_DISABLE, getCallOptions()), request);
    }

    /**
     * <pre>
     * Authenticate processes an authenticate request.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthenticateResponse> authenticate(
        etcdserverpb.Rpc.AuthenticateRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_AUTHENTICATE, getCallOptions()), request);
    }

    /**
     * <pre>
     * UserAdd adds a new user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthUserAddResponse> userAdd(
        etcdserverpb.Rpc.AuthUserAddRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_USER_ADD, getCallOptions()), request);
    }

    /**
     * <pre>
     * UserGet gets detailed user information.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthUserGetResponse> userGet(
        etcdserverpb.Rpc.AuthUserGetRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_USER_GET, getCallOptions()), request);
    }

    /**
     * <pre>
     * UserList gets a list of all users.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthUserListResponse> userList(
        etcdserverpb.Rpc.AuthUserListRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_USER_LIST, getCallOptions()), request);
    }

    /**
     * <pre>
     * UserDelete deletes a specified user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthUserDeleteResponse> userDelete(
        etcdserverpb.Rpc.AuthUserDeleteRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_USER_DELETE, getCallOptions()), request);
    }

    /**
     * <pre>
     * UserChangePassword changes the password of a specified user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthUserChangePasswordResponse> userChangePassword(
        etcdserverpb.Rpc.AuthUserChangePasswordRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_USER_CHANGE_PASSWORD, getCallOptions()), request);
    }

    /**
     * <pre>
     * UserGrant grants a role to a specified user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthUserGrantRoleResponse> userGrantRole(
        etcdserverpb.Rpc.AuthUserGrantRoleRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_USER_GRANT_ROLE, getCallOptions()), request);
    }

    /**
     * <pre>
     * UserRevokeRole revokes a role of specified user.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthUserRevokeRoleResponse> userRevokeRole(
        etcdserverpb.Rpc.AuthUserRevokeRoleRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_USER_REVOKE_ROLE, getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleAdd adds a new role.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthRoleAddResponse> roleAdd(
        etcdserverpb.Rpc.AuthRoleAddRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_ROLE_ADD, getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleGet gets detailed role information.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthRoleGetResponse> roleGet(
        etcdserverpb.Rpc.AuthRoleGetRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_ROLE_GET, getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleList gets lists of all roles.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthRoleListResponse> roleList(
        etcdserverpb.Rpc.AuthRoleListRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_ROLE_LIST, getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleDelete deletes a specified role.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthRoleDeleteResponse> roleDelete(
        etcdserverpb.Rpc.AuthRoleDeleteRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_ROLE_DELETE, getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleGrantPermission grants a permission of a specified key or range to a specified role.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthRoleGrantPermissionResponse> roleGrantPermission(
        etcdserverpb.Rpc.AuthRoleGrantPermissionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_ROLE_GRANT_PERMISSION, getCallOptions()), request);
    }

    /**
     * <pre>
     * RoleRevokePermission revokes a key or range permission of a specified role.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.AuthRoleRevokePermissionResponse> roleRevokePermission(
        etcdserverpb.Rpc.AuthRoleRevokePermissionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_ROLE_REVOKE_PERMISSION, getCallOptions()), request);
    }
  }

  private static final int METHODID_AUTH_ENABLE = 0;
  private static final int METHODID_AUTH_DISABLE = 1;
  private static final int METHODID_AUTHENTICATE = 2;
  private static final int METHODID_USER_ADD = 3;
  private static final int METHODID_USER_GET = 4;
  private static final int METHODID_USER_LIST = 5;
  private static final int METHODID_USER_DELETE = 6;
  private static final int METHODID_USER_CHANGE_PASSWORD = 7;
  private static final int METHODID_USER_GRANT_ROLE = 8;
  private static final int METHODID_USER_REVOKE_ROLE = 9;
  private static final int METHODID_ROLE_ADD = 10;
  private static final int METHODID_ROLE_GET = 11;
  private static final int METHODID_ROLE_LIST = 12;
  private static final int METHODID_ROLE_DELETE = 13;
  private static final int METHODID_ROLE_GRANT_PERMISSION = 14;
  private static final int METHODID_ROLE_REVOKE_PERMISSION = 15;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AuthImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(AuthImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_AUTH_ENABLE:
          serviceImpl.authEnable((etcdserverpb.Rpc.AuthEnableRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthEnableResponse>) responseObserver);
          break;
        case METHODID_AUTH_DISABLE:
          serviceImpl.authDisable((etcdserverpb.Rpc.AuthDisableRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthDisableResponse>) responseObserver);
          break;
        case METHODID_AUTHENTICATE:
          serviceImpl.authenticate((etcdserverpb.Rpc.AuthenticateRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthenticateResponse>) responseObserver);
          break;
        case METHODID_USER_ADD:
          serviceImpl.userAdd((etcdserverpb.Rpc.AuthUserAddRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserAddResponse>) responseObserver);
          break;
        case METHODID_USER_GET:
          serviceImpl.userGet((etcdserverpb.Rpc.AuthUserGetRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserGetResponse>) responseObserver);
          break;
        case METHODID_USER_LIST:
          serviceImpl.userList((etcdserverpb.Rpc.AuthUserListRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserListResponse>) responseObserver);
          break;
        case METHODID_USER_DELETE:
          serviceImpl.userDelete((etcdserverpb.Rpc.AuthUserDeleteRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserDeleteResponse>) responseObserver);
          break;
        case METHODID_USER_CHANGE_PASSWORD:
          serviceImpl.userChangePassword((etcdserverpb.Rpc.AuthUserChangePasswordRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserChangePasswordResponse>) responseObserver);
          break;
        case METHODID_USER_GRANT_ROLE:
          serviceImpl.userGrantRole((etcdserverpb.Rpc.AuthUserGrantRoleRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserGrantRoleResponse>) responseObserver);
          break;
        case METHODID_USER_REVOKE_ROLE:
          serviceImpl.userRevokeRole((etcdserverpb.Rpc.AuthUserRevokeRoleRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthUserRevokeRoleResponse>) responseObserver);
          break;
        case METHODID_ROLE_ADD:
          serviceImpl.roleAdd((etcdserverpb.Rpc.AuthRoleAddRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleAddResponse>) responseObserver);
          break;
        case METHODID_ROLE_GET:
          serviceImpl.roleGet((etcdserverpb.Rpc.AuthRoleGetRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleGetResponse>) responseObserver);
          break;
        case METHODID_ROLE_LIST:
          serviceImpl.roleList((etcdserverpb.Rpc.AuthRoleListRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleListResponse>) responseObserver);
          break;
        case METHODID_ROLE_DELETE:
          serviceImpl.roleDelete((etcdserverpb.Rpc.AuthRoleDeleteRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleDeleteResponse>) responseObserver);
          break;
        case METHODID_ROLE_GRANT_PERMISSION:
          serviceImpl.roleGrantPermission((etcdserverpb.Rpc.AuthRoleGrantPermissionRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleGrantPermissionResponse>) responseObserver);
          break;
        case METHODID_ROLE_REVOKE_PERMISSION:
          serviceImpl.roleRevokePermission((etcdserverpb.Rpc.AuthRoleRevokePermissionRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.AuthRoleRevokePermissionResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class AuthBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    AuthBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return etcdserverpb.Rpc.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Auth");
    }
  }

  private static final class AuthFileDescriptorSupplier
      extends AuthBaseDescriptorSupplier {
    AuthFileDescriptorSupplier() {}
  }

  private static final class AuthMethodDescriptorSupplier
      extends AuthBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    AuthMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (AuthGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new AuthFileDescriptorSupplier())
              .addMethod(METHOD_AUTH_ENABLE)
              .addMethod(METHOD_AUTH_DISABLE)
              .addMethod(METHOD_AUTHENTICATE)
              .addMethod(METHOD_USER_ADD)
              .addMethod(METHOD_USER_GET)
              .addMethod(METHOD_USER_LIST)
              .addMethod(METHOD_USER_DELETE)
              .addMethod(METHOD_USER_CHANGE_PASSWORD)
              .addMethod(METHOD_USER_GRANT_ROLE)
              .addMethod(METHOD_USER_REVOKE_ROLE)
              .addMethod(METHOD_ROLE_ADD)
              .addMethod(METHOD_ROLE_GET)
              .addMethod(METHOD_ROLE_LIST)
              .addMethod(METHOD_ROLE_DELETE)
              .addMethod(METHOD_ROLE_GRANT_PERMISSION)
              .addMethod(METHOD_ROLE_REVOKE_PERMISSION)
              .build();
        }
      }
    }
    return result;
  }
}
