/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.router.masterslave.ShardingMasterSlaveRouter;
import io.shardingsphere.core.routing.router.sharding.ShardingRouter;
import io.shardingsphere.core.routing.router.sharding.ShardingRouterFactory;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.List;

public final class PreparedStatementRoutingEngine {
    private final String logicSQL;
    private final ShardingRouter shardingRouter;
    private final ShardingMasterSlaveRouter masterSlaveRouter;
    private SQLStatement sqlStatement;

    public PreparedStatementRoutingEngine(String logicSQL, ShardingRule shardingRule, ShardingMetaData shardingMetaData, DatabaseType databaseType, boolean showSQL) {
        this.logicSQL = logicSQL;
        this.shardingRouter = ShardingRouterFactory.newInstance(shardingRule, shardingMetaData, databaseType, showSQL);
        this.masterSlaveRouter = new ShardingMasterSlaveRouter(shardingRule.getMasterSlaveRules());
    }

    public SQLRouteResult route(List<Object> parameters) {
        if (null == this.sqlStatement) {
            this.sqlStatement = this.shardingRouter.parse(this.logicSQL, true);
        }
        return this.masterSlaveRouter.route(this.shardingRouter.route(this.logicSQL, parameters, this.sqlStatement));
    }
}

