/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl.ddl.alter;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.ColumnDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.alter.ModifyColumnDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.position.ColumnPositionSegment;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.rule.ShardingRule;

public final class ModifyColumnDefinitionFiller
implements SQLStatementFiller<ModifyColumnDefinitionSegment> {
    @Override
    public void fill(ModifyColumnDefinitionSegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        AlterTableStatement alterTableStatement = (AlterTableStatement)sqlStatement;
        Optional<String> oldColumnName = sqlSegment.getOldColumnName();
        if (oldColumnName.isPresent()) {
            Optional<ColumnDefinitionSegment> oldColumnDefinition = alterTableStatement.findColumnDefinition((String)oldColumnName.get(), shardingTableMetaData);
            if (!oldColumnDefinition.isPresent()) {
                return;
            }
            ((ColumnDefinitionSegment)oldColumnDefinition.get()).setColumnName(sqlSegment.getColumnDefinition().getColumnName());
            if (null != sqlSegment.getColumnDefinition().getDataType()) {
                ((ColumnDefinitionSegment)oldColumnDefinition.get()).setDataType(sqlSegment.getColumnDefinition().getDataType());
            }
            alterTableStatement.getModifiedColumnDefinitions().put((String)oldColumnName.get(), (ColumnDefinitionSegment)oldColumnDefinition.get());
        } else {
            alterTableStatement.getModifiedColumnDefinitions().put(sqlSegment.getColumnDefinition().getColumnName(), sqlSegment.getColumnDefinition());
        }
        if (sqlSegment.getColumnPosition().isPresent()) {
            alterTableStatement.getChangedPositionColumns().add((ColumnPositionSegment)sqlSegment.getColumnPosition().get());
        }
    }
}

