/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.table;

import io.shardingsphere.core.metadata.table.TableMetaData;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class ShardingTableMetaData {
    private final Map<String, TableMetaData> tables;

    public TableMetaData get(String logicTableName) {
        return this.tables.get(logicTableName);
    }

    public void put(String logicTableName, TableMetaData tableMetaData) {
        this.tables.put(logicTableName, tableMetaData);
    }

    public void remove(String logicTableName) {
        this.tables.remove(logicTableName);
    }

    public boolean containsTable(String tableName) {
        return this.tables.containsKey(tableName);
    }

    public boolean containsColumn(String tableName, String column) {
        return this.containsTable(tableName) && this.tables.get(tableName).getColumns().keySet().contains(column.toLowerCase());
    }

    public Collection<String> getAllColumnNames(String tableName) {
        return this.tables.containsKey(tableName) ? this.tables.get(tableName).getColumns().keySet() : Collections.emptyList();
    }

    @ConstructorProperties(value={"tables"})
    public ShardingTableMetaData(Map<String, TableMetaData> tables) {
        this.tables = tables;
    }

    public Map<String, TableMetaData> getTables() {
        return this.tables;
    }
}

