/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.datasource;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.dialect.H2DataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.dialect.MySQLDataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.dialect.OracleDataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.dialect.PostgreSQLDataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.dialect.SQLServerDataSourceMetaData;

public final class DataSourceMetaDataFactory {
    public static DataSourceMetaData newInstance(DatabaseType databaseType, String url) {
        switch (databaseType) {
            case H2: {
                return new H2DataSourceMetaData(url);
            }
            case MySQL: {
                return new MySQLDataSourceMetaData(url);
            }
            case Oracle: {
                return new OracleDataSourceMetaData(url);
            }
            case PostgreSQL: {
                return new PostgreSQLDataSourceMetaData(url);
            }
            case SQLServer: {
                return new SQLServerDataSourceMetaData(url);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{databaseType}));
    }

    private DataSourceMetaDataFactory() {
    }
}

