/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute.result;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.shardingsphere.core.executor.sql.execute.row.QueryRow;
import io.shardingsphere.core.merger.QueryResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class MemoryQueryResult
implements QueryResult {
    private final Multimap<String, Integer> columnLabelAndIndexMap;
    private final Iterator<QueryRow> resultData;
    private QueryRow currentRow;

    public MemoryQueryResult(ResultSet resultSet) throws SQLException {
        this.columnLabelAndIndexMap = this.getMetaData(resultSet.getMetaData());
        this.resultData = this.getResultData(resultSet);
    }

    private Multimap<String, Integer> getMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        HashMultimap result = HashMultimap.create();
        for (int columnIndex = 1; columnIndex <= resultSetMetaData.getColumnCount(); ++columnIndex) {
            result.put((Object)resultSetMetaData.getColumnLabel(columnIndex), (Object)columnIndex);
        }
        return result;
    }

    private Iterator<QueryRow> getResultData(ResultSet resultSet) throws SQLException {
        LinkedList<QueryRow> result = new LinkedList<QueryRow>();
        while (resultSet.next()) {
            ArrayList<Object> rowData = new ArrayList<Object>(this.columnLabelAndIndexMap.size());
            for (int columnIndex = 1; columnIndex <= resultSet.getMetaData().getColumnCount(); ++columnIndex) {
                rowData.add(resultSet.getObject(columnIndex));
            }
            result.add(new QueryRow(rowData));
        }
        return result.iterator();
    }

    @Override
    public boolean next() {
        if (this.resultData.hasNext()) {
            this.currentRow = this.resultData.next();
            return true;
        }
        this.currentRow = null;
        return false;
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) {
        return this.currentRow.getColumnValue(columnIndex);
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) {
        return this.currentRow.getColumnValue(this.getColumnIndex(columnLabel));
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        return this.currentRow.getColumnValue(columnIndex);
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) {
        return this.currentRow.getColumnValue(this.getColumnIndex(columnLabel));
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) {
        return this.getInputStream(this.currentRow.getColumnValue(columnIndex));
    }

    @Override
    public InputStream getInputStream(String columnLabel, String type) {
        return this.getInputStream(this.currentRow.getColumnValue(this.getColumnIndex(columnLabel)));
    }

    private InputStream getInputStream(Object value) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(value);
        objectOutputStream.flush();
        objectOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public boolean wasNull() {
        return null == this.currentRow;
    }

    @Override
    public int getColumnCount() {
        return this.columnLabelAndIndexMap.size();
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        for (Map.Entry entry : this.columnLabelAndIndexMap.entries()) {
            if (columnIndex != (Integer)entry.getValue()) continue;
            return (String)entry.getKey();
        }
        throw new SQLException("Column index out of range", "9999");
    }

    private Integer getColumnIndex(String columnLabel) {
        return (Integer)new ArrayList(this.columnLabelAndIndexMap.get((Object)columnLabel)).get(0);
    }
}

