/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.AntlrParsingEngine;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.TokenType;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingUnsupportedException;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.describe.DescribeParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dal.set.SetParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dal.show.ShowParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dal.use.UseParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dcl.DCLStatement;
import io.shardingsphere.core.parsing.parser.sql.dcl.alter.AlterUserParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dcl.create.CreateUserParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dcl.deny.DenyUserParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dcl.drop.DropUserParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dcl.grant.GrantUserParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dcl.rename.RenameUserParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dcl.revoke.RevokeUserParserFactory;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.DMLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.delete.DeleteParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dml.update.UpdateParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectParserFactory;
import io.shardingsphere.core.parsing.parser.sql.tcl.TCLStatement;
import io.shardingsphere.core.parsing.parser.sql.tcl.begin.BeginParserFactory;
import io.shardingsphere.core.parsing.parser.sql.tcl.commit.CommitParserFactory;
import io.shardingsphere.core.parsing.parser.sql.tcl.rollback.RollbcakParserFactory;
import io.shardingsphere.core.parsing.parser.sql.tcl.savepoint.SavepointParserFactory;
import io.shardingsphere.core.parsing.parser.sql.tcl.set.autocommit.SetAutoCommitParserFactory;
import io.shardingsphere.core.parsing.parser.sql.tcl.set.transaction.SetTransactionParserFactory;
import io.shardingsphere.core.rule.ShardingRule;

public final class SQLParserFactory {
    public static SQLParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData, String sql) {
        lexerEngine.nextToken();
        TokenType tokenType = lexerEngine.getCurrentToken().getType();
        if (DQLStatement.isDQL(tokenType)) {
            if (DatabaseType.MySQL == dbType) {
                return new AntlrParsingEngine(dbType, sql, shardingRule, shardingTableMetaData);
            }
            return SQLParserFactory.getDQLParser(dbType, shardingRule, lexerEngine, shardingTableMetaData);
        }
        if (DMLStatement.isDML(tokenType)) {
            return SQLParserFactory.getDMLParser(dbType, tokenType, shardingRule, lexerEngine, shardingTableMetaData);
        }
        if (TCLStatement.isTCL(tokenType)) {
            return SQLParserFactory.getTCLParser(dbType, tokenType, lexerEngine);
        }
        if (DALStatement.isDAL(tokenType)) {
            return SQLParserFactory.getDALParser(dbType, (Keyword)tokenType, shardingRule, lexerEngine);
        }
        lexerEngine.nextToken();
        TokenType secondaryTokenType = lexerEngine.getCurrentToken().getType();
        if (DCLStatement.isDCL(tokenType, secondaryTokenType)) {
            return SQLParserFactory.getDCLParser(dbType, tokenType, shardingRule, lexerEngine);
        }
        if (DDLStatement.isDDL(tokenType, secondaryTokenType)) {
            return new AntlrParsingEngine(dbType, sql, shardingRule, shardingTableMetaData);
        }
        if (DCLStatement.isDCL(tokenType, secondaryTokenType)) {
            return SQLParserFactory.getDCLParser(dbType, tokenType, shardingRule, lexerEngine);
        }
        if (TCLStatement.isTCLUnsafe(dbType, tokenType, lexerEngine)) {
            return SQLParserFactory.getTCLParser(dbType, tokenType, lexerEngine);
        }
        if (DefaultKeyword.SET.equals(tokenType)) {
            return SetParserFactory.newInstance();
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private static SQLParser getDQLParser(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        return SelectParserFactory.newInstance(dbType, shardingRule, lexerEngine, shardingTableMetaData);
    }

    private static SQLParser getDMLParser(DatabaseType dbType, TokenType tokenType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        switch ((DefaultKeyword)tokenType) {
            case INSERT: {
                return InsertParserFactory.newInstance(dbType, shardingRule, lexerEngine, shardingTableMetaData);
            }
            case UPDATE: {
                return UpdateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DELETE: {
                return DeleteParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private static SQLParser getDALParser(DatabaseType dbType, Keyword tokenType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        if (DefaultKeyword.USE == tokenType) {
            return UseParserFactory.newInstance(dbType, shardingRule, lexerEngine);
        }
        if (DefaultKeyword.DESC == tokenType || MySQLKeyword.DESCRIBE == tokenType) {
            return DescribeParserFactory.newInstance(dbType, shardingRule, lexerEngine);
        }
        if (MySQLKeyword.SHOW == tokenType) {
            return ShowParserFactory.newInstance(dbType, shardingRule, lexerEngine);
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private static SQLParser getDCLParser(DatabaseType dbType, TokenType tokenType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch ((DefaultKeyword)tokenType) {
            case CREATE: {
                return CreateUserParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case ALTER: {
                return AlterUserParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DROP: {
                return DropUserParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case RENAME: {
                return RenameUserParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case GRANT: {
                return GrantUserParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case REVOKE: {
                return RevokeUserParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DENY: {
                return DenyUserParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private static SQLParser getTCLParser(DatabaseType dbType, TokenType primaryTokenType, LexerEngine lexerEngine) {
        switch ((DefaultKeyword)primaryTokenType) {
            case SET: {
                if (DefaultKeyword.TRANSACTION.equals(lexerEngine.getCurrentToken().getType())) {
                    return SetTransactionParserFactory.newInstance();
                }
                return SetAutoCommitParserFactory.newInstance(dbType, lexerEngine);
            }
            case COMMIT: {
                return CommitParserFactory.newInstance();
            }
            case ROLLBACK: {
                return RollbcakParserFactory.newInstance();
            }
            case SAVEPOINT: {
                return SavepointParserFactory.newInstance();
            }
            case BEGIN: {
                return BeginParserFactory.newInstance();
            }
            case IF: {
                if (DatabaseType.SQLServer != dbType) break;
                return SetAutoCommitParserFactory.newInstance(dbType, lexerEngine);
            }
        }
        throw new SQLParsingUnsupportedException(primaryTokenType);
    }

    private SQLParserFactory() {
    }
}

