/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.context.selectitem;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingsphere.core.util.SQLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class DistinctSelectItem
implements SelectItem {
    private final List<String> distinctColumnNames = new LinkedList<String>();
    private final Optional<String> alias;

    public DistinctSelectItem(Collection<String> distinctColumnNames, Optional<String> alias) {
        this.distinctColumnNames.addAll(distinctColumnNames);
        this.alias = alias;
    }

    @Override
    public String getExpression() {
        return this.distinctColumnNames.isEmpty() ? DefaultKeyword.DISTINCT.name() : SQLUtil.getExactlyValue(DefaultKeyword.DISTINCT + " " + Joiner.on((String)", ").join(this.distinctColumnNames));
    }

    public String getColumnLabel() {
        return this.alias.isPresent() ? (String)this.alias.get() : this.getExpression();
    }

    public Collection<String> getDistinctColumnLabels() {
        return this.alias.isPresent() ? this.getDistinctColumnLabels((String)this.alias.get()) : this.distinctColumnNames;
    }

    private Collection<String> getDistinctColumnLabels(String alias) {
        if (1 == this.distinctColumnNames.size()) {
            return Collections.singletonList(alias);
        }
        LinkedList<String> result = new LinkedList<String>(this.distinctColumnNames);
        result.set(0, alias);
        return result;
    }

    public List<String> getDistinctColumnNames() {
        return this.distinctColumnNames;
    }

    @Override
    public Optional<String> getAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DistinctSelectItem)) {
            return false;
        }
        DistinctSelectItem other = (DistinctSelectItem)o;
        List<String> this$distinctColumnNames = this.getDistinctColumnNames();
        List<String> other$distinctColumnNames = other.getDistinctColumnNames();
        if (this$distinctColumnNames == null ? other$distinctColumnNames != null : !((Object)this$distinctColumnNames).equals(other$distinctColumnNames)) {
            return false;
        }
        Optional<String> this$alias = this.getAlias();
        Optional<String> other$alias = other.getAlias();
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $distinctColumnNames = this.getDistinctColumnNames();
        result = result * 59 + ($distinctColumnNames == null ? 0 : ((Object)$distinctColumnNames).hashCode());
        Optional<String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 0 : $alias.hashCode());
        return result;
    }

    public String toString() {
        return "DistinctSelectItem(distinctColumnNames=" + this.getDistinctColumnNames() + ", alias=" + this.getAlias() + ")";
    }
}

