/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.rule.registry;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.rule.jaxb.loader.RuleDefinitionFileConstant;
import io.shardingsphere.core.parsing.antlr.rule.jaxb.loader.extractor.ExtractorRuleDefinitionEntityLoader;
import io.shardingsphere.core.parsing.antlr.rule.jaxb.loader.filler.FillerRuleDefinitionEntityLoader;
import io.shardingsphere.core.parsing.antlr.rule.jaxb.loader.statement.SQLStatementRuleDefinitionEntityLoader;
import io.shardingsphere.core.parsing.antlr.rule.registry.extractor.ExtractorRuleDefinition;
import io.shardingsphere.core.parsing.antlr.rule.registry.filler.FillerRuleDefinition;
import io.shardingsphere.core.parsing.antlr.rule.registry.statement.SQLStatementRule;
import io.shardingsphere.core.parsing.antlr.rule.registry.statement.SQLStatementRuleDefinition;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import java.util.HashMap;
import java.util.Map;

public final class ParsingRuleRegistry {
    private static volatile ParsingRuleRegistry instance;
    private final SQLStatementRuleDefinitionEntityLoader statementRuleDefinitionLoader = new SQLStatementRuleDefinitionEntityLoader();
    private final ExtractorRuleDefinitionEntityLoader extractorRuleDefinitionLoader = new ExtractorRuleDefinitionEntityLoader();
    private final FillerRuleDefinitionEntityLoader fillerRuleDefinitionLoader = new FillerRuleDefinitionEntityLoader();
    private final Map<DatabaseType, SQLStatementRuleDefinition> statementRuleDefinitions = new HashMap<DatabaseType, SQLStatementRuleDefinition>(4, 1.0f);
    private final FillerRuleDefinition fillerRuleDefinition = new FillerRuleDefinition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParsingRuleRegistry getInstance() {
        if (null != instance) return instance;
        Class<ParsingRuleRegistry> clazz = ParsingRuleRegistry.class;
        synchronized (ParsingRuleRegistry.class) {
            if (null != instance) return instance;
            instance = new ParsingRuleRegistry();
            instance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private synchronized void init() {
        for (DatabaseType each : DatabaseType.values()) {
            if (DatabaseType.H2 == each) continue;
            this.statementRuleDefinitions.put(each, this.init(each));
        }
        this.fillerRuleDefinition.init(this.fillerRuleDefinitionLoader.load(RuleDefinitionFileConstant.getFillerRuleDefinitionFileName()));
    }

    private SQLStatementRuleDefinition init(DatabaseType databaseType) {
        ExtractorRuleDefinition extractorRuleDefinition = new ExtractorRuleDefinition();
        extractorRuleDefinition.init(this.extractorRuleDefinitionLoader.load(RuleDefinitionFileConstant.getCommonExtractorRuleDefinitionFileName()), this.extractorRuleDefinitionLoader.load(RuleDefinitionFileConstant.getExtractorRuleDefinitionFileName(databaseType)));
        SQLStatementRuleDefinition result = new SQLStatementRuleDefinition();
        result.init(this.statementRuleDefinitionLoader.load(RuleDefinitionFileConstant.getSQLStatementRuleDefinitionFileName(databaseType)), extractorRuleDefinition);
        return result;
    }

    public Optional<SQLStatementRule> findSQLStatementRule(DatabaseType databaseType, String contextClassName) {
        return Optional.fromNullable((Object)this.statementRuleDefinitions.get((Object)(DatabaseType.H2 == databaseType ? DatabaseType.MySQL : databaseType)).getRules().get(contextClassName));
    }

    public Optional<SQLStatementFiller> findSQLStatementFiller(Class<? extends SQLSegment> sqlSegmentClass) {
        return Optional.fromNullable((Object)this.fillerRuleDefinition.getRules().get(sqlSegmentClass));
    }

    private ParsingRuleRegistry() {
    }
}

