/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.parser;

import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.statement.ResetParamStatement;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.statement.SetParamStatement;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.statement.ShowStatement;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingUnsupportedException;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.create.table.CreateTableStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.sql.tcl.begin.BeginStatement;
import io.shardingsphere.core.parsing.parser.sql.tcl.commit.CommitStatement;
import io.shardingsphere.core.parsing.parser.sql.tcl.rollback.RollbackStatement;
import io.shardingsphere.core.parsing.parser.sql.tcl.savepoint.SavepointStatement;
import io.shardingsphere.core.parsing.parser.sql.tcl.set.autocommit.SetAutoCommitStatement;
import io.shardingsphere.core.parsing.parser.sql.tcl.set.transaction.SetTransactionStatement;

public enum SQLStatementType {
    CREATE_TABLE("CreateTable", CreateTableStatement.class),
    ALTER_TABLE("AlterTable", AlterTableStatement.class),
    DROP_TABLE("DropTable", DDLStatement.class),
    TRUNCATE_TABLE("TruncateTable", DDLStatement.class),
    CREATE_INDEX("CreateIndex", DDLStatement.class),
    ALTER_INDEX("AlterIndex", DDLStatement.class),
    DROP_INDEX("DropIndex", DDLStatement.class),
    SELECT("Select", SelectStatement.class),
    SET_TRANSACTION("SetTransaction", SetTransactionStatement.class),
    COMMIT("Commit", CommitStatement.class),
    ROLLBACK("Rollback", RollbackStatement.class),
    SAVEPOINT("Savepoint", SavepointStatement.class),
    BEGIN_WORK("BeginWork", BeginStatement.class),
    SET_AUTO_COMMIT("SetAutoCommit", SetAutoCommitStatement.class),
    SHOW("Show", ShowStatement.class),
    SET_PARAM("SetParam", SetParamStatement.class),
    RESET_PARAM("ResetParam", ResetParamStatement.class);

    private final String name;
    private final Class<? extends SQLStatement> clazz;

    public static SQLStatementType nameOf(String name) {
        for (SQLStatementType each : SQLStatementType.values()) {
            if (!(each.name + "Context").equals(name)) continue;
            return each;
        }
        throw new SQLParsingUnsupportedException(String.format("Unsupported SQL statement of `%s`", name));
    }

    private SQLStatementType(String name, Class<? extends SQLStatement> clazz) {
        this.name = name;
        this.clazz = clazz;
    }
}

