/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.optimizer.impl.ddl;

import io.shardingsphere.core.metadata.table.ColumnMetaData;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.TableMetaData;
import io.shardingsphere.core.parsing.antlr.optimizer.SQLStatementOptimizer;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.ColumnDefinition;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AlterTableOptimizer
implements SQLStatementOptimizer {
    @Override
    public final void optimize(SQLStatement sqlStatement, ShardingTableMetaData shardingTableMetaData) {
        AlterTableStatement alterTableStatement = (AlterTableStatement)sqlStatement;
        TableMetaData oldTableMetaData = shardingTableMetaData.get(alterTableStatement.getTables().getSingleTableName());
        if (null == oldTableMetaData) {
            return;
        }
        List<ColumnMetaData> newColumnMetaData = this.getUpdatedColumnMetaDataList(alterTableStatement, oldTableMetaData);
        this.fillColumnDefinition(alterTableStatement, newColumnMetaData);
        this.adjustColumnDefinition(alterTableStatement, newColumnMetaData);
        this.dropColumnDefinition(alterTableStatement, newColumnMetaData);
        alterTableStatement.setTableMetaData(new TableMetaData(newColumnMetaData));
    }

    private List<ColumnMetaData> getUpdatedColumnMetaDataList(AlterTableStatement alterTableStatement, TableMetaData oldTableMetaData) {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        for (ColumnMetaData each : oldTableMetaData.getColumnMetaData()) {
            boolean primaryKey;
            String columnType;
            String columnName;
            ColumnDefinition updatedColumnDefinition = alterTableStatement.getUpdateColumns().get(each.getColumnName());
            if (null == updatedColumnDefinition) {
                columnName = each.getColumnName();
                columnType = each.getColumnType();
                primaryKey = !alterTableStatement.isDropPrimaryKey() && each.isPrimaryKey();
            } else {
                columnName = updatedColumnDefinition.getName();
                columnType = updatedColumnDefinition.getType();
                primaryKey = !alterTableStatement.isDropPrimaryKey() && updatedColumnDefinition.isPrimaryKey();
            }
            result.add(new ColumnMetaData(columnName, columnType, primaryKey));
        }
        return result;
    }

    private void fillColumnDefinition(AlterTableStatement alterTableStatement, List<ColumnMetaData> newColumnMetaData) {
        for (ColumnDefinition each : alterTableStatement.getAddColumns()) {
            newColumnMetaData.add(new ColumnMetaData(each.getName(), each.getType(), each.isPrimaryKey()));
        }
    }

    protected void adjustColumnDefinition(AlterTableStatement alterTableStatement, List<ColumnMetaData> newColumnMetaData) {
    }

    private void dropColumnDefinition(AlterTableStatement alterTableStatement, List<ColumnMetaData> newColumnMetaData) {
        Iterator<ColumnMetaData> iterator = newColumnMetaData.iterator();
        while (iterator.hasNext()) {
            ColumnMetaData each = iterator.next();
            if (!alterTableStatement.getDropColumns().contains(each.getColumnName())) continue;
            iterator.remove();
        }
    }
}

