/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.CollectionSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.IndexSegment;
import io.shardingsphere.core.parsing.parser.token.IndexToken;
import io.shardingsphere.core.util.SQLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public final class RenameIndexExtractor
implements CollectionSQLSegmentExtractor {
    public Collection<IndexSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> renameIndexNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.RENAME_INDEX);
        if (!renameIndexNode.isPresent() || 4 > ((ParserRuleContext)renameIndexNode.get()).getChildCount()) {
            return Collections.emptyList();
        }
        ParseTree oldIndexNode = ((ParserRuleContext)renameIndexNode.get()).getChild(2);
        if (!(oldIndexNode instanceof ParserRuleContext)) {
            return Collections.emptyList();
        }
        ParseTree newIndexNode = ((ParserRuleContext)renameIndexNode.get()).getChild(4);
        if (!(newIndexNode instanceof ParserRuleContext)) {
            return Collections.emptyList();
        }
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        result.add(this.getIndexToken((ParserRuleContext)newIndexNode));
        result.add(this.getIndexToken((ParserRuleContext)oldIndexNode));
        return result;
    }

    private IndexSegment getIndexToken(ParserRuleContext indexNode) {
        String name = SQLUtil.getNameWithoutSchema(indexNode.getText());
        return new IndexSegment(name, new IndexToken(indexNode.getStop().getStartIndex(), name));
    }
}

