/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.IndexSegment;
import io.shardingsphere.core.parsing.parser.token.IndexToken;
import io.shardingsphere.core.util.SQLUtil;
import org.antlr.v4.runtime.ParserRuleContext;

public final class IndexNameExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<IndexSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> indexNameNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.INDEX_NAME);
        if (!indexNameNode.isPresent()) {
            return Optional.absent();
        }
        String indexName = SQLUtil.getNameWithoutSchema(((ParserRuleContext)indexNameNode.get()).getText());
        return Optional.of((Object)new IndexSegment(indexName, new IndexToken(((ParserRuleContext)indexNameNode.get()).getStop().getStartIndex(), indexName)));
    }
}

