/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ColumnSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.SubqueryExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.CommonExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.ExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.FunctionExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.PropertyExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.StarExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SubquerySegment;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.util.SQLUtil;
import java.util.HashMap;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class ExpressionExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<ExpressionSegment> extract(ParserRuleContext expressionNode) {
        String firstChildText = expressionNode.getText();
        if (firstChildText.endsWith(Symbol.STAR.getLiterals())) {
            int position = firstChildText.indexOf(Symbol.DOT.getLiterals());
            Optional owner = Optional.absent();
            if (0 < position) {
                owner = Optional.of((Object)SQLUtil.getExactlyValue(firstChildText.substring(0, position)));
            }
            return Optional.of((Object)new StarExpressionSegment(expressionNode.getStart().getStartIndex(), (Optional<String>)owner));
        }
        Optional<ParserRuleContext> subqueryNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.SUBQUERY);
        if (subqueryNode.isPresent()) {
            Optional<SubquerySegment> subquerySegment = new SubqueryExtractor().extract((ParserRuleContext)subqueryNode.get());
            if (subquerySegment.isPresent()) {
                return Optional.of((Object)subquerySegment.get());
            }
            return Optional.absent();
        }
        return this.fillForPropertyOrFunction(expressionNode);
    }

    private Optional<ExpressionSegment> fillForPropertyOrFunction(ParserRuleContext node) {
        Optional<ParserRuleContext> aliasNode = ExtractorUtils.findFirstChildNode(node, RuleName.ALIAS);
        Optional alias = aliasNode.isPresent() ? Optional.of((Object)SQLUtil.getExactlyValue(((ParserRuleContext)aliasNode.get()).getText())) : Optional.absent();
        Optional<ParserRuleContext> functionCall = ExtractorUtils.findFirstChildNode(node, RuleName.FUNCTION_CALL);
        if (functionCall.isPresent()) {
            String name = ((ParserRuleContext)functionCall.get()).getChild(0).getText();
            int startIndex = ((TerminalNode)((ParserRuleContext)functionCall.get()).getChild(1)).getSymbol().getStartIndex();
            boolean hasDistinct = this.hasDistinct(node);
            int distinctColumnNameStartPosition = hasDistinct ? this.calculateDistinctColumnNamePosition((ParserRuleContext)functionCall.get()) : -1;
            return Optional.of((Object)new FunctionExpressionSegment(name, (Optional<String>)alias, ((ParserRuleContext)functionCall.get()).getStart().getStartIndex(), startIndex, ((ParserRuleContext)functionCall.get()).getStop().getStopIndex(), hasDistinct, distinctColumnNameStartPosition));
        }
        if (RuleName.COLUMN_NAME.getName().equals(node.getChild(0).getClass().getSimpleName())) {
            ParserRuleContext columnNode = (ParserRuleContext)node.getChild(0);
            Optional<ColumnSegment> columnSegment = new ColumnSegmentExtractor(new HashMap<String, String>()).extract(columnNode);
            return Optional.of((Object)new PropertyExpressionSegment(((ColumnSegment)columnSegment.get()).getOwner(), ((ColumnSegment)columnSegment.get()).getName(), columnNode.getStart().getStartIndex(), columnNode.getStop().getStopIndex(), (Optional<String>)alias));
        }
        return Optional.of((Object)new CommonExpressionSegment(node.getStart().getStartIndex(), node.getStop().getStopIndex(), (Optional<String>)alias));
    }

    private boolean hasDistinct(ParserRuleContext node) {
        return ExtractorUtils.findFirstChildNode(node, RuleName.DISTINCT).isPresent();
    }

    private int calculateDistinctColumnNamePosition(ParserRuleContext functionNode) {
        ParseTree distinctItemNode = functionNode.getChild(3);
        if (distinctItemNode instanceof TerminalNode) {
            return ((TerminalNode)distinctItemNode).getSymbol().getStartIndex();
        }
        if (distinctItemNode instanceof ParserRuleContext) {
            return ((ParserRuleContext)distinctItemNode).getStart().getStartIndex();
        }
        return -1;
    }
}

