/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.DropColumnSegment;
import io.shardingsphere.core.util.SQLUtil;
import java.util.Collection;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public final class DropColumnExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<DropColumnSegment> extract(ParserRuleContext ancestorNode) {
        Collection<ParserRuleContext> dropColumnNodes = ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.DROP_COLUMN);
        if (dropColumnNodes.isEmpty()) {
            return Optional.absent();
        }
        DropColumnSegment result = new DropColumnSegment();
        for (ParserRuleContext each : dropColumnNodes) {
            for (ParseTree parseTree : ExtractorUtils.getAllDescendantNodes(each, RuleName.COLUMN_NAME)) {
                result.getDropColumnNames().add(SQLUtil.getExactlyValue(parseTree.getText()));
            }
        }
        return Optional.of((Object)result);
    }
}

