/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.extractor.SQLSegmentsExtractorEngine;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFillerEngine;
import io.shardingsphere.core.parsing.antlr.optimizer.SQLStatementOptimizerEngine;
import io.shardingsphere.core.parsing.antlr.parser.SQLAST;
import io.shardingsphere.core.parsing.antlr.parser.SQLParserEngine;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.Collection;

public final class AntlrParsingEngine
implements SQLParser {
    private final SQLParserEngine parserEngine;
    private final SQLSegmentsExtractorEngine extractorEngine;
    private final SQLStatementFillerEngine fillerEngine;
    private final SQLStatementOptimizerEngine optimizerEngine;

    public AntlrParsingEngine(DatabaseType databaseType, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        this.parserEngine = new SQLParserEngine(databaseType, sql);
        this.extractorEngine = new SQLSegmentsExtractorEngine();
        this.fillerEngine = new SQLStatementFillerEngine(sql, shardingRule, shardingTableMetaData);
        this.optimizerEngine = new SQLStatementOptimizerEngine(shardingTableMetaData);
    }

    @Override
    public SQLStatement parse() {
        SQLAST ast = this.parserEngine.parse();
        Collection<SQLSegment> sqlSegments = this.extractorEngine.extract(ast);
        SQLStatement result = this.fillerEngine.fill(sqlSegments, ast.getRule());
        this.optimizerEngine.optimize(ast.getRule(), result);
        return result;
    }
}

