/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.table;

import io.shardingsphere.core.metadata.table.TableMetaData;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class ShardingTableMetaData {
    private final Map<String, TableMetaData> tableMetaDataMap;

    public TableMetaData get(String logicTableName) {
        return this.tableMetaDataMap.get(logicTableName);
    }

    public void put(String logicTableName, TableMetaData tableMetaData) {
        this.tableMetaDataMap.put(logicTableName, tableMetaData);
    }

    public boolean containsTable(String tableName) {
        return this.tableMetaDataMap.containsKey(tableName);
    }

    public boolean containsColumn(String tableName, String column) {
        return this.containsTable(tableName) && this.tableMetaDataMap.get(tableName).getAllColumnNames().contains(column.toLowerCase());
    }

    public Collection<String> getAllColumnNames(String tableName) {
        TableMetaData tableMeta = this.tableMetaDataMap.get(tableName);
        if (null == tableMeta) {
            return Collections.emptyList();
        }
        return tableMeta.getAllColumnNames();
    }

    @ConstructorProperties(value={"tableMetaDataMap"})
    public ShardingTableMetaData(Map<String, TableMetaData> tableMetaDataMap) {
        this.tableMetaDataMap = tableMetaDataMap;
    }

    public Map<String, TableMetaData> getTableMetaDataMap() {
        return this.tableMetaDataMap;
    }
}

