/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.datasource.dialect;

import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class H2DataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = -1;
    private final String hostName;
    private final int port;
    private final String schemeName;
    private final Pattern pattern = Pattern.compile("jdbc:h2:(mem|~)[:/]([\\w\\-]+);?\\S*", 2);

    public H2DataSourceMetaData(String url) {
        Matcher matcher = this.pattern.matcher(url);
        if (!matcher.find()) {
            throw new ShardingException("The URL of JDBC is not supported. Please refer to this pattern: %s.", this.pattern.pattern());
        }
        this.hostName = matcher.group(1);
        this.port = -1;
        this.schemeName = matcher.group(2);
    }

    @Override
    public boolean isInSameDatabaseInstance(DataSourceMetaData dataSourceMetaData) {
        return this.hostName.equals(dataSourceMetaData.getHostName()) && this.port == dataSourceMetaData.getPort() && this.schemeName.equals(dataSourceMetaData.getSchemeName());
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getSchemeName() {
        return this.schemeName;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

