/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute.row;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;

public final class QueryRow {
    private final List<Object> rowData;
    private final List<Integer> distinctColumnIndexes = new LinkedList<Integer>();

    public QueryRow(List<Object> rowData, List<Integer> distinctColumnIndexes) {
        this.rowData = rowData;
        this.distinctColumnIndexes.addAll(distinctColumnIndexes);
    }

    public Object getColumnValue(int columnIndex) {
        return this.rowData.get(columnIndex - 1);
    }

    public boolean equals(Object obj) {
        return this == obj || null != obj && this.getClass() == obj.getClass() && this.isEqual((QueryRow)obj);
    }

    private boolean isEqual(QueryRow queryRow) {
        if (this.distinctColumnIndexes.isEmpty()) {
            return this.rowData.equals(queryRow.getRowData());
        }
        return this.distinctColumnIndexes.equals(queryRow.getDistinctColumnIndexes()) && this.isEqualByPart(queryRow);
    }

    private boolean isEqualByPart(QueryRow queryRow) {
        for (int i = 0; i < this.distinctColumnIndexes.size(); ++i) {
            if (this.rowData.get(i).equals(queryRow.getRowData().get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.distinctColumnIndexes.isEmpty() ? this.rowData.hashCode() : Lists.transform(this.distinctColumnIndexes, (Function)new Function<Integer, Object>(){

            public Object apply(Integer input) {
                return QueryRow.this.rowData.get(input - 1);
            }
        }).hashCode();
    }

    @ConstructorProperties(value={"rowData"})
    public QueryRow(List<Object> rowData) {
        this.rowData = rowData;
    }

    public List<Object> getRowData() {
        return this.rowData;
    }

    public List<Integer> getDistinctColumnIndexes() {
        return this.distinctColumnIndexes;
    }
}

