/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.constant.properties;

import io.shardingsphere.core.constant.transaction.TransactionType;

public enum ShardingPropertiesConstant {
    SQL_SHOW("sql.show", String.valueOf(Boolean.FALSE), Boolean.TYPE),
    ACCEPTOR_SIZE("acceptor.size", String.valueOf(Runtime.getRuntime().availableProcessors() * 2), Integer.TYPE),
    EXECUTOR_SIZE("executor.size", String.valueOf(0), Integer.TYPE),
    MAX_CONNECTIONS_SIZE_PER_QUERY("max.connections.size.per.query", String.valueOf(1), Integer.TYPE),
    PROXY_FRONTEND_FLUSH_THRESHOLD("proxy.frontend.flush.threshold", String.valueOf(128), Integer.TYPE),
    PROXY_TRANSACTION_TYPE("proxy.transaction.type", TransactionType.LOCAL.name(), String.class),
    PROXY_OPENTRACING_ENABLED("proxy.opentracing.enabled", String.valueOf(Boolean.FALSE), Boolean.TYPE),
    PROXY_BACKEND_USE_NIO("proxy.backend.use.nio", String.valueOf(Boolean.FALSE), Boolean.TYPE),
    PROXY_BACKEND_MAX_CONNECTIONS("proxy.backend.max.connections", String.valueOf(8), Integer.TYPE),
    PROXY_BACKEND_CONNECTION_TIMEOUT_SECONDS("proxy.backend.connection.timeout.seconds", String.valueOf(60), Integer.TYPE);

    private final String key;
    private final String defaultValue;
    private final Class<?> type;

    public static ShardingPropertiesConstant findByKey(String key) {
        for (ShardingPropertiesConstant each : ShardingPropertiesConstant.values()) {
            if (!each.getKey().equals(key)) continue;
            return each;
        }
        return null;
    }

    private ShardingPropertiesConstant(String key, String defaultValue, Class<?> type) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Class<?> getType() {
        return this.type;
    }
}

