/*
 * Copyright 2016-2018 shardingsphere.io.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * </p>
 */

package io.shardingsphere.core.parsing.antlr.sql.segment;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import lombok.Getter;

/**
 * Limit segment.
 * 
 * @author duhongjun
 */
@Getter
public final class LimitSegment implements SQLSegment {
    
    private final DatabaseType databaseType;
    
    private final LimitValueSegment rowCount;
    
    private final Optional<LimitValueSegment> offset;
    
    public LimitSegment(final DatabaseType databaseType, final LimitValueSegment rowCount, final Optional<LimitValueSegment> offset) {
        this.databaseType = databaseType;
        this.rowCount = rowCount;
        this.offset = offset;
    }
    
    public LimitSegment(final DatabaseType databaseType, final LimitValueSegment rowCount) {
        this.databaseType = databaseType;
        this.rowCount = rowCount;
        this.offset = Optional.absent();
    }
}
