/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.spi.executor;

import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.spi.NewInstanceServiceLoader;
import io.shardingsphere.spi.executor.SQLExecutionHook;
import java.util.Collection;

public final class SPISQLExecutionHook
implements SQLExecutionHook {
    private static final NewInstanceServiceLoader<SQLExecutionHook> SERVICE_LOADER = NewInstanceServiceLoader.load(SQLExecutionHook.class);
    private final Collection<SQLExecutionHook> sqlExecutionHooks = SERVICE_LOADER.newServiceInstances();

    @Override
    public void start(RouteUnit routeUnit, DataSourceMetaData dataSourceMetaData, boolean isTrunkThread) {
        for (SQLExecutionHook each : this.sqlExecutionHooks) {
            each.start(routeUnit, dataSourceMetaData, isTrunkThread);
        }
    }

    @Override
    public void finishSuccess() {
        for (SQLExecutionHook each : this.sqlExecutionHooks) {
            each.finishSuccess();
        }
    }

    @Override
    public void finishFailure(Exception cause) {
        for (SQLExecutionHook each : this.sqlExecutionHooks) {
            each.finishFailure(cause);
        }
    }
}

