/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.router.masterslave.ShardingMasterSlaveRouter;
import io.shardingsphere.core.routing.router.sharding.ShardingRouter;
import io.shardingsphere.core.routing.router.sharding.ShardingRouterFactory;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.List;

public final class PreparedStatementRoutingEngine {
    private final String logicSQL;
    private final ShardingRouter shardingRouter;
    private final ShardingMasterSlaveRouter masterSlaveRouter;
    private SQLStatement sqlStatement;

    public PreparedStatementRoutingEngine(String logicSQL, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData, DatabaseType databaseType, boolean showSQL, ShardingDataSourceMetaData shardingDataSourceMetaData) {
        this.logicSQL = logicSQL;
        this.shardingRouter = ShardingRouterFactory.createSQLRouter(shardingRule, shardingTableMetaData, databaseType, showSQL, shardingDataSourceMetaData);
        this.masterSlaveRouter = new ShardingMasterSlaveRouter(shardingRule.getMasterSlaveRules());
    }

    public SQLRouteResult route(List<Object> parameters) {
        if (null == this.sqlStatement) {
            this.sqlStatement = this.shardingRouter.parse(this.logicSQL, true);
        }
        return this.masterSlaveRouter.route(this.shardingRouter.route(this.logicSQL, parameters, this.sqlStatement));
    }
}

