/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.dml.update;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLUpdateParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleUpdateParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLUpdateParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerUpdateParser;
import io.shardingsphere.core.parsing.parser.sql.dml.update.AbstractUpdateParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class UpdateParserFactory {
    public static AbstractUpdateParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLUpdateParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleUpdateParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerUpdateParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLUpdateParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private UpdateParserFactory() {
    }
}

