/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.context.condition;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.parser.clause.condition.NullCondition;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.Condition;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class AndCondition {
    private final List<Condition> conditions = new LinkedList<Condition>();

    public Map<Column, List<Condition>> getConditionsMap() {
        LinkedHashMap<Column, List<Condition>> result = new LinkedHashMap<Column, List<Condition>>(this.conditions.size(), 1.0f);
        for (Condition each : this.conditions) {
            if (!result.containsKey(each.getColumn())) {
                result.put(each.getColumn(), new LinkedList());
            }
            ((List)result.get(each.getColumn())).add(each);
        }
        return result;
    }

    public AndCondition optimize() {
        AndCondition result = new AndCondition();
        for (Condition each : this.conditions) {
            if (!Condition.class.equals(each.getClass())) continue;
            result.getConditions().add(each);
        }
        if (result.getConditions().isEmpty()) {
            result.getConditions().add(new NullCondition());
        }
        return result;
    }

    @Deprecated
    public Optional<Condition> find(Column column) {
        Condition result = null;
        for (Condition each : this.conditions) {
            if (!Objects.equal((Object)each.getColumn(), (Object)column)) continue;
            result = each;
        }
        return Optional.fromNullable(result);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public String toString() {
        return "AndCondition(conditions=" + this.getConditions() + ")";
    }
}

