/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.table.executor;

import com.google.common.collect.Lists;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.ShardingGroupExecuteCallback;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.metadata.table.ColumnMetaData;
import io.shardingsphere.core.metadata.table.TableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingDataSourceNames;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class TableMetaDataLoader {
    private final ShardingDataSourceMetaData shardingDataSourceMetaData;
    private final ShardingExecuteEngine executeEngine;
    private final TableMetaDataConnectionManager connectionManager;
    private final int maxConnectionsSizePerQuery;

    public TableMetaData load(String logicTableName, ShardingRule shardingRule) throws SQLException {
        List<TableMetaData> actualTableMetaDataList = this.load(shardingRule.getTableRuleByLogicTableName(logicTableName).getDataNodeGroups(), shardingRule.getShardingDataSourceNames());
        this.checkUniformed(logicTableName, actualTableMetaDataList);
        return actualTableMetaDataList.iterator().next();
    }

    private List<TableMetaData> load(Map<String, List<DataNode>> dataNodeGroups, final ShardingDataSourceNames shardingDataSourceNames) throws SQLException {
        return this.executeEngine.groupExecute(this.getDataNodeGroups(dataNodeGroups), new ShardingGroupExecuteCallback<DataNode, TableMetaData>(){

            @Override
            public Collection<TableMetaData> execute(Collection<DataNode> dataNodes, boolean isTrunkThread) throws SQLException {
                String dataSourceName = dataNodes.iterator().next().getDataSourceName();
                DataSourceMetaData dataSourceMetaData = TableMetaDataLoader.this.shardingDataSourceMetaData.getActualDataSourceMetaData(dataSourceName);
                String catalog = null == dataSourceMetaData ? null : dataSourceMetaData.getSchemeName();
                return TableMetaDataLoader.this.load(shardingDataSourceNames.getRawMasterDataSourceName(dataSourceName), catalog, dataNodes);
            }
        });
    }

    private Collection<TableMetaData> load(String dataSourceName, String catalog, Collection<DataNode> dataNodes) throws SQLException {
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        try (Connection connection = this.connectionManager.getConnection(dataSourceName);){
            for (DataNode each : dataNodes) {
                result.add(new TableMetaData(this.isTableExist(connection, catalog, each.getTableName()) ? this.getColumnMetaDataList(connection, catalog, each.getTableName()) : Collections.emptyList()));
            }
        }
        return result;
    }

    private Collection<ShardingExecuteGroup<DataNode>> getDataNodeGroups(Map<String, List<DataNode>> dataNodeGroups) {
        LinkedList<ShardingExecuteGroup<DataNode>> result = new LinkedList<ShardingExecuteGroup<DataNode>>();
        for (Map.Entry<String, List<DataNode>> entry : dataNodeGroups.entrySet()) {
            result.addAll(this.getDataNodeGroups(entry.getValue()));
        }
        return result;
    }

    private Collection<ShardingExecuteGroup<DataNode>> getDataNodeGroups(List<DataNode> dataNodes) {
        LinkedList<ShardingExecuteGroup<DataNode>> result = new LinkedList<ShardingExecuteGroup<DataNode>>();
        for (List each : Lists.partition(dataNodes, (int)Math.max(dataNodes.size() / this.maxConnectionsSizePerQuery, 1))) {
            result.add(new ShardingExecuteGroup(each));
        }
        return result;
    }

    private boolean isTableExist(Connection connection, String catalog, String actualTableName) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(catalog, null, actualTableName, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    private List<ColumnMetaData> getColumnMetaDataList(Connection connection, String catalog, String actualTableName) throws SQLException {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> primaryKeys = this.getPrimaryKeys(connection, catalog, actualTableName);
        try (ResultSet resultSet = connection.getMetaData().getColumns(catalog, null, actualTableName, null);){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                String columnType = resultSet.getString("TYPE_NAME");
                result.add(new ColumnMetaData(columnName, columnType, primaryKeys.contains(columnName)));
            }
        }
        return result;
    }

    private Collection<String> getPrimaryKeys(Connection connection, String catalog, String actualTableName) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(catalog, null, actualTableName);){
            while (resultSet.next()) {
                result.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return result;
    }

    private void checkUniformed(String logicTableName, List<TableMetaData> actualTableMetaDataList) {
        TableMetaData sample = actualTableMetaDataList.iterator().next();
        for (TableMetaData each : actualTableMetaDataList) {
            if (sample.equals(each)) continue;
            throw new ShardingException("Cannot get uniformed table structure for `%s`. The different meta data of actual tables are as follows:\n%s\n%s.", logicTableName, sample, each);
        }
    }

    @ConstructorProperties(value={"shardingDataSourceMetaData", "executeEngine", "connectionManager", "maxConnectionsSizePerQuery"})
    public TableMetaDataLoader(ShardingDataSourceMetaData shardingDataSourceMetaData, ShardingExecuteEngine executeEngine, TableMetaDataConnectionManager connectionManager, int maxConnectionsSizePerQuery) {
        this.shardingDataSourceMetaData = shardingDataSourceMetaData;
        this.executeEngine = executeEngine;
        this.connectionManager = connectionManager;
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
    }
}

