/*
 * Copyright 2016-2018 shardingsphere.io.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * </p>
 */

package io.shardingsphere.spi.root;

import io.shardingsphere.spi.NewInstanceServiceLoader;

import java.util.Collection;

/**
 * Root invoke hook for SPI.
 *
 * @author zhangliang
 */
public final class SPIRootInvokeHook implements RootInvokeHook {
    
    private static final NewInstanceServiceLoader<RootInvokeHook> SERVICE_LOADER = NewInstanceServiceLoader.load(RootInvokeHook.class);
    
    private final Collection<RootInvokeHook> rootInvokeHooks = SERVICE_LOADER.newServiceInstances();
    
    @Override
    public void start() {
        for (RootInvokeHook each : rootInvokeHooks) {
            each.start();
        }
    }
    
    @Override
    public void finish(final int connectionCount) {
        for (RootInvokeHook each : rootInvokeHooks) {
            each.finish(connectionCount);
        }
    }
}
