/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.util;

import com.google.common.base.Joiner;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.RouteUnit;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLLogger {
    private static final Logger log = LoggerFactory.getLogger((String)"Sharding-Sphere-SQL");

    public static void logSQL(String logicSQL, SQLStatement sqlStatement, Collection<RouteUnit> routeUnits) {
        SQLLogger.log("Rule Type: sharding", new Object[0]);
        SQLLogger.log("Logic SQL: {}", logicSQL);
        SQLLogger.log("SQLStatement: {}", sqlStatement);
        for (RouteUnit each : routeUnits) {
            if (each.getSqlUnit().getParameterSets().get(0).isEmpty()) {
                SQLLogger.log("Actual SQL: {} ::: {}", each.getDataSourceName(), each.getSqlUnit().getSql());
                continue;
            }
            SQLLogger.log("Actual SQL: {} ::: {} ::: {}", each.getDataSourceName(), each.getSqlUnit().getSql(), each.getSqlUnit().getParameterSets());
        }
    }

    public static void logSQL(String logicSQL, Collection<String> dataSourceNames) {
        SQLLogger.log("Rule Type: master-slave", new Object[0]);
        SQLLogger.log("SQL: {} ::: DataSources: {}", logicSQL, Joiner.on((String)",").join(dataSourceNames));
    }

    private static void log(String pattern, Object ... arguments) {
        log.info(pattern, arguments);
    }

    private SQLLogger() {
    }
}

