/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.drop.table;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLDropTableParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleDropTableParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLDropTableParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerDropTableParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.drop.table.AbstractDropTableParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class DropTableParserFactory {
    public static AbstractDropTableParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLDropTableParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleDropTableParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerDropTableParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLDropTableParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private DropTableParserFactory() {
    }
}

