/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.alter.table;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLAlterTableParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleAlterTableParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLAlterTableParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerAlterTableParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.alter.table.AbstractAlterTableParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class AlterTableParserFactory {
    public static AbstractAlterTableParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLAlterTableParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleAlterTableParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerAlterTableParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLAlterTableParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private AlterTableParserFactory() {
    }
}

