/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.cache;

import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import java.util.Map;
import java.util.WeakHashMap;

public final class ParsingResultCache {
    private static final ParsingResultCache INSTANCE = new ParsingResultCache();
    private final Map<String, SQLStatement> cache = new WeakHashMap<String, SQLStatement>(65535, 1.0f);

    public static ParsingResultCache getInstance() {
        return INSTANCE;
    }

    public void put(String sql, SQLStatement sqlStatement) {
        this.cache.put(sql, sqlStatement);
    }

    public SQLStatement getSQLStatement(String sql) {
        return this.cache.get(sql);
    }

    public synchronized void clear() {
        this.cache.clear();
    }
}

