/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.LexerEngineFactory;
import io.shardingsphere.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingsphere.core.parsing.lexer.token.Assist;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.lexer.token.TokenType;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.DescribeStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.SetStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowColumnsStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowDatabasesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowIndexStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowOtherStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTableStatusStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTablesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.UseStatement;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dcl.DCLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.DMLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.sql.tcl.TCLStatement;
import io.shardingsphere.core.parsing.parser.token.SchemaToken;
import java.beans.ConstructorProperties;

public final class SQLJudgeEngine {
    private final String sql;

    public SQLStatement judge() {
        TokenType tokenType;
        LexerEngine lexerEngine = LexerEngineFactory.newInstance(DatabaseType.MySQL, this.sql);
        lexerEngine.nextToken();
        do {
            if ((tokenType = lexerEngine.getCurrentToken().getType()) instanceof Keyword) {
                if (DQLStatement.isDQL(tokenType)) {
                    return this.getDQLStatement();
                }
                if (DMLStatement.isDML(tokenType)) {
                    return this.getDMLStatement(tokenType);
                }
                if (TCLStatement.isTCL(tokenType)) {
                    return this.getTCLStatement(tokenType);
                }
                if (DALStatement.isDAL(tokenType)) {
                    return this.getDALStatement(tokenType, lexerEngine);
                }
                lexerEngine.nextToken();
                TokenType secondaryTokenType = lexerEngine.getCurrentToken().getType();
                if (DDLStatement.isDDL(tokenType, secondaryTokenType)) {
                    return this.getDDLStatement();
                }
                if (!DCLStatement.isDCL(tokenType, secondaryTokenType)) continue;
                return this.getDCLStatement();
            }
            lexerEngine.nextToken();
        } while (!(tokenType instanceof Assist) || Assist.END != tokenType);
        throw new SQLParsingException("Unsupported SQL statement: [%s]", this.sql);
    }

    private SQLStatement getDQLStatement() {
        return new SelectStatement();
    }

    private SQLStatement getDMLStatement(TokenType tokenType) {
        if (DefaultKeyword.INSERT == tokenType) {
            return new InsertStatement();
        }
        return new DMLStatement();
    }

    private SQLStatement getDDLStatement() {
        return new DDLStatement();
    }

    private SQLStatement getDCLStatement() {
        return new DCLStatement();
    }

    private SQLStatement getTCLStatement(TokenType tokenType) {
        if (DefaultKeyword.SET == tokenType) {
            return new SetStatement();
        }
        return new TCLStatement();
    }

    private SQLStatement getDALStatement(TokenType tokenType, LexerEngine lexerEngine) {
        if (DefaultKeyword.USE == tokenType) {
            lexerEngine.nextToken();
            return new UseStatement(lexerEngine.getCurrentToken().getLiterals());
        }
        if (DefaultKeyword.DESC == tokenType || MySQLKeyword.DESCRIBE == tokenType) {
            return new DescribeStatement();
        }
        return this.getShowStatement(lexerEngine);
    }

    private SQLStatement getShowStatement(LexerEngine lexerEngine) {
        lexerEngine.nextToken();
        lexerEngine.skipIfEqual(DefaultKeyword.FULL);
        if (lexerEngine.equalAny(MySQLKeyword.DATABASES)) {
            return new ShowDatabasesStatement();
        }
        if (lexerEngine.skipIfEqual(DefaultKeyword.TABLE, MySQLKeyword.STATUS)) {
            return this.parseShowTableStatus(lexerEngine);
        }
        if (lexerEngine.skipIfEqual(MySQLKeyword.TABLES)) {
            return this.parseShowTables(lexerEngine);
        }
        if (lexerEngine.skipIfEqual(MySQLKeyword.COLUMNS, MySQLKeyword.FIELDS)) {
            return this.parseShowColumnsFields(lexerEngine);
        }
        if (lexerEngine.skipIfEqual(DefaultKeyword.INDEX, MySQLKeyword.INDEXES, MySQLKeyword.KEYS)) {
            return this.parseShowIndex(lexerEngine);
        }
        return new ShowOtherStatement();
    }

    private DALStatement parseShowTables(LexerEngine lexerEngine) {
        ShowTablesStatement result = new ShowTablesStatement();
        if (lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
            result.getSqlTokens().add(new SchemaToken(beginPosition, lexerEngine.getCurrentToken().getLiterals(), null));
        }
        return result;
    }

    private DALStatement parseShowColumnsFields(LexerEngine lexerEngine) {
        ShowColumnsStatement result = new ShowColumnsStatement();
        lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
        this.parseSingleTableWithSchema(lexerEngine, result);
        if (lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
            result.getSqlTokens().add(new SchemaToken(beginPosition, lexerEngine.getCurrentToken().getLiterals(), null));
        }
        return result;
    }

    private void parseSingleTableWithSchema(LexerEngine lexerEngine, SQLStatement sqlStatement) {
        int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
        String literals = lexerEngine.getCurrentToken().getLiterals();
        lexerEngine.nextToken();
        if (lexerEngine.skipIfEqual(Symbol.DOT)) {
            sqlStatement.getSqlTokens().add(new SchemaToken(beginPosition, literals, null));
            lexerEngine.nextToken();
        }
    }

    private DALStatement parseShowIndex(LexerEngine lexerEngine) {
        ShowIndexStatement result = new ShowIndexStatement();
        lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
        this.parseSingleTableWithSchema(lexerEngine, result);
        if (lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
            result.getSqlTokens().add(new SchemaToken(beginPosition, lexerEngine.getCurrentToken().getLiterals(), null));
        }
        return result;
    }

    private DALStatement parseShowTableStatus(LexerEngine lexerEngine) {
        ShowTableStatusStatement result = new ShowTableStatusStatement();
        lexerEngine.nextToken();
        if (lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
            result.getSqlTokens().add(new SchemaToken(beginPosition, lexerEngine.getCurrentToken().getLiterals(), null));
        }
        return result;
    }

    @ConstructorProperties(value={"sql"})
    public SQLJudgeEngine(String sql) {
        this.sql = sql;
    }
}

