/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.optimizer.query;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import io.shardingsphere.api.algorithm.sharding.ListShardingValue;
import io.shardingsphere.api.algorithm.sharding.RangeShardingValue;
import io.shardingsphere.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.constant.ShardingOperator;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.optimizer.OptimizeEngine;
import io.shardingsphere.core.optimizer.condition.ShardingCondition;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.optimizer.query.AlwaysFalseShardingCondition;
import io.shardingsphere.core.optimizer.query.AlwaysFalseShardingValue;
import io.shardingsphere.core.parsing.parser.context.condition.AndCondition;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.Condition;
import io.shardingsphere.core.parsing.parser.context.condition.OrCondition;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class QueryOptimizeEngine
implements OptimizeEngine {
    private final OrCondition orCondition;
    private final List<Object> parameters;

    @Override
    public ShardingConditions optimize() {
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>(this.orCondition.getAndConditions().size());
        for (AndCondition each : this.orCondition.getAndConditions()) {
            result.add(this.optimize(each.getConditionsMap()));
        }
        return new ShardingConditions(result);
    }

    private ShardingCondition optimize(Map<Column, List<Condition>> conditionsMap) {
        ShardingCondition result = new ShardingCondition();
        for (Map.Entry<Column, List<Condition>> entry : conditionsMap.entrySet()) {
            try {
                ShardingValue shardingValue = this.optimize(entry.getKey(), entry.getValue());
                if (shardingValue instanceof AlwaysFalseShardingValue) {
                    return new AlwaysFalseShardingCondition();
                }
                result.getShardingValues().add(shardingValue);
            }
            catch (ClassCastException ex) {
                throw new ShardingException("Found different types for sharding value `%s`.", entry.getKey());
            }
        }
        return result;
    }

    private ShardingValue optimize(Column column, List<Condition> conditions) {
        List<Comparable<?>> listValue = null;
        Range<Comparable<?>> rangeValue = null;
        for (Condition each : conditions) {
            List<Comparable<?>> conditionValues = each.getConditionValues(this.parameters);
            if ((ShardingOperator.EQUAL == each.getOperator() || ShardingOperator.IN == each.getOperator()) && (listValue = this.optimize(conditionValues, listValue)).isEmpty()) {
                return new AlwaysFalseShardingValue();
            }
            if (ShardingOperator.BETWEEN != each.getOperator()) continue;
            try {
                rangeValue = this.optimize(Range.range(conditionValues.get(0), (BoundType)BoundType.CLOSED, conditionValues.get(1), (BoundType)BoundType.CLOSED), rangeValue);
            }
            catch (IllegalArgumentException ex) {
                return new AlwaysFalseShardingValue();
            }
        }
        if (null == listValue) {
            return new RangeShardingValue(column.getTableName(), column.getName(), rangeValue);
        }
        if (null == rangeValue) {
            return new ListShardingValue(column.getTableName(), column.getName(), listValue);
        }
        return (listValue = this.optimize(listValue, rangeValue)).isEmpty() ? new AlwaysFalseShardingValue() : new ListShardingValue(column.getTableName(), column.getName(), listValue);
    }

    private List<Comparable<?>> optimize(List<Comparable<?>> value1, List<Comparable<?>> value2) {
        if (null == value2) {
            return value1;
        }
        value1.retainAll(value2);
        return value1;
    }

    private Range<Comparable<?>> optimize(Range<Comparable<?>> value1, Range<Comparable<?>> value2) {
        return null == value2 ? value1 : value1.intersection(value2);
    }

    private List<Comparable<?>> optimize(List<Comparable<?>> listValue, Range<Comparable<?>> rangeValue) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : listValue) {
            if (!rangeValue.contains(each)) continue;
            result.add(each);
        }
        return result;
    }

    @ConstructorProperties(value={"orCondition", "parameters"})
    public QueryOptimizeEngine(OrCondition orCondition, List<Object> parameters) {
        this.orCondition = orCondition;
        this.parameters = parameters;
    }
}

