/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute;

import com.google.common.eventbus.EventBus;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.event.executor.SQLExecutionEvent;
import io.shardingsphere.core.event.executor.SQLExecutionEventFactory;
import io.shardingsphere.core.executor.ShardingExecuteCallback;
import io.shardingsphere.core.executor.ShardingGroupExecuteCallback;
import io.shardingsphere.core.executor.StatementExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaDataFactory;
import io.shardingsphere.spi.executor.SPISQLExecutionHook;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class SQLExecuteCallback<T>
implements ShardingExecuteCallback<StatementExecuteUnit, T>,
ShardingGroupExecuteCallback<StatementExecuteUnit, T> {
    private final DatabaseType databaseType;
    private final SQLType sqlType;
    private final boolean isExceptionThrown;
    private final EventBus shardingEventBus = ShardingEventBusInstance.getInstance();

    @Override
    public final T execute(StatementExecuteUnit statementExecuteUnit, boolean isTrunkThread) throws SQLException {
        return this.execute0(statementExecuteUnit, isTrunkThread);
    }

    @Override
    public final Collection<T> execute(Collection<StatementExecuteUnit> statementExecuteUnits, boolean isTrunkThread) throws SQLException {
        LinkedList<T> result = new LinkedList<T>();
        for (StatementExecuteUnit each : statementExecuteUnits) {
            result.add(this.execute0(each, isTrunkThread));
        }
        return result;
    }

    private T execute0(StatementExecuteUnit statementExecuteUnit, boolean isTrunkThread) throws SQLException {
        ExecutorExceptionHandler.setExceptionThrown(this.isExceptionThrown);
        List<List<Object>> parameterSets = statementExecuteUnit.getRouteUnit().getSqlUnit().getParameterSets();
        DataSourceMetaData dataSourceMetaData = DataSourceMetaDataFactory.newInstance(this.databaseType, statementExecuteUnit.getStatement().getConnection().getMetaData().getURL());
        SPISQLExecutionHook sqlExecutionHook = new SPISQLExecutionHook();
        for (List<Object> each : parameterSets) {
            this.shardingEventBus.post((Object)SQLExecutionEventFactory.createEvent(this.sqlType, statementExecuteUnit, each, dataSourceMetaData));
        }
        try {
            sqlExecutionHook.start(statementExecuteUnit.getRouteUnit(), dataSourceMetaData, isTrunkThread);
            T result = this.executeSQL(statementExecuteUnit);
            sqlExecutionHook.finishSuccess();
            for (List<Object> each : parameterSets) {
                SQLExecutionEvent finishEvent = SQLExecutionEventFactory.createEvent(this.sqlType, statementExecuteUnit, each, dataSourceMetaData);
                finishEvent.setExecuteSuccess();
                this.shardingEventBus.post((Object)finishEvent);
            }
            return result;
        }
        catch (SQLException ex) {
            sqlExecutionHook.finishFailure(ex);
            for (List<Object> each : parameterSets) {
                SQLExecutionEvent finishEvent = SQLExecutionEventFactory.createEvent(this.sqlType, statementExecuteUnit, each, dataSourceMetaData);
                finishEvent.setExecuteFailure(ex);
                this.shardingEventBus.post((Object)finishEvent);
            }
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
    }

    protected abstract T executeSQL(StatementExecuteUnit var1) throws SQLException;

    @ConstructorProperties(value={"databaseType", "sqlType", "isExceptionThrown"})
    public SQLExecuteCallback(DatabaseType databaseType, SQLType sqlType, boolean isExceptionThrown) {
        this.databaseType = databaseType;
        this.sqlType = sqlType;
        this.isExceptionThrown = isExceptionThrown;
    }
}

