/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.yaml.sharding;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingsphere.core.api.config.TableRuleConfiguration;
import io.shardingsphere.core.keygen.KeyGeneratorFactory;
import io.shardingsphere.core.yaml.sharding.YamlShardingStrategyConfiguration;

public class YamlTableRuleConfiguration {
    private String logicTable;
    private String actualDataNodes;
    private YamlShardingStrategyConfiguration databaseStrategy;
    private YamlShardingStrategyConfiguration tableStrategy;
    private String keyGeneratorColumnName;
    private String keyGeneratorClassName;
    private String logicIndex;

    public YamlTableRuleConfiguration(TableRuleConfiguration tableRuleConfiguration) {
        this.logicTable = tableRuleConfiguration.getLogicTable();
        this.actualDataNodes = tableRuleConfiguration.getActualDataNodes();
        this.databaseStrategy = new YamlShardingStrategyConfiguration(tableRuleConfiguration.getDatabaseShardingStrategyConfig());
        this.tableStrategy = new YamlShardingStrategyConfiguration(tableRuleConfiguration.getTableShardingStrategyConfig());
        this.keyGeneratorColumnName = tableRuleConfiguration.getKeyGeneratorColumnName();
        this.keyGeneratorClassName = null == tableRuleConfiguration.getKeyGenerator() ? null : tableRuleConfiguration.getKeyGenerator().getClass().getName();
    }

    public TableRuleConfiguration build() {
        Preconditions.checkNotNull((Object)this.logicTable, (Object)"Logic table cannot be null.");
        TableRuleConfiguration result = new TableRuleConfiguration();
        result.setLogicTable(this.logicTable);
        result.setActualDataNodes(this.actualDataNodes);
        if (null != this.databaseStrategy) {
            result.setDatabaseShardingStrategyConfig(this.databaseStrategy.build());
        }
        if (null != this.tableStrategy) {
            result.setTableShardingStrategyConfig(this.tableStrategy.build());
        }
        if (!Strings.isNullOrEmpty((String)this.keyGeneratorClassName)) {
            result.setKeyGenerator(KeyGeneratorFactory.newInstance(this.keyGeneratorClassName));
        }
        result.setKeyGeneratorColumnName(this.keyGeneratorColumnName);
        result.setLogicIndex(this.logicIndex);
        return result;
    }

    public YamlTableRuleConfiguration() {
    }

    public String getLogicTable() {
        return this.logicTable;
    }

    public String getActualDataNodes() {
        return this.actualDataNodes;
    }

    public YamlShardingStrategyConfiguration getDatabaseStrategy() {
        return this.databaseStrategy;
    }

    public YamlShardingStrategyConfiguration getTableStrategy() {
        return this.tableStrategy;
    }

    public String getKeyGeneratorColumnName() {
        return this.keyGeneratorColumnName;
    }

    public String getKeyGeneratorClassName() {
        return this.keyGeneratorClassName;
    }

    public String getLogicIndex() {
        return this.logicIndex;
    }

    public void setLogicTable(String logicTable) {
        this.logicTable = logicTable;
    }

    public void setActualDataNodes(String actualDataNodes) {
        this.actualDataNodes = actualDataNodes;
    }

    public void setDatabaseStrategy(YamlShardingStrategyConfiguration databaseStrategy) {
        this.databaseStrategy = databaseStrategy;
    }

    public void setTableStrategy(YamlShardingStrategyConfiguration tableStrategy) {
        this.tableStrategy = tableStrategy;
    }

    public void setKeyGeneratorColumnName(String keyGeneratorColumnName) {
        this.keyGeneratorColumnName = keyGeneratorColumnName;
    }

    public void setKeyGeneratorClassName(String keyGeneratorClassName) {
        this.keyGeneratorClassName = keyGeneratorClassName;
    }

    public void setLogicIndex(String logicIndex) {
        this.logicIndex = logicIndex;
    }
}

