/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rule;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.config.TableRuleConfiguration;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.keygen.KeyGenerator;
import io.shardingsphere.core.routing.strategy.ShardingStrategy;
import io.shardingsphere.core.routing.strategy.ShardingStrategyFactory;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingDataSourceNames;
import io.shardingsphere.core.util.InlineExpressionParser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class TableRule {
    private final String logicTable;
    private final List<DataNode> actualDataNodes;
    private final Map<DataNode, Integer> dataNodeIndexMap;
    private final ShardingStrategy databaseShardingStrategy;
    private final ShardingStrategy tableShardingStrategy;
    private final String generateKeyColumn;
    private final KeyGenerator keyGenerator;
    private final String logicIndex;

    public TableRule(String defaultDataSourceName, String logicTableName) {
        this.logicTable = logicTableName.toLowerCase();
        this.actualDataNodes = Collections.singletonList(new DataNode(defaultDataSourceName, logicTableName));
        this.dataNodeIndexMap = Collections.emptyMap();
        this.databaseShardingStrategy = null;
        this.tableShardingStrategy = null;
        this.generateKeyColumn = null;
        this.keyGenerator = null;
        this.logicIndex = null;
    }

    public TableRule(TableRuleConfiguration tableRuleConfig, ShardingDataSourceNames shardingDataSourceNames) {
        Preconditions.checkNotNull((Object)tableRuleConfig.getLogicTable(), (Object)"Logic table cannot be null.");
        this.logicTable = tableRuleConfig.getLogicTable().toLowerCase();
        List<String> dataNodes = new InlineExpressionParser(tableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        this.dataNodeIndexMap = new HashMap<DataNode, Integer>(dataNodes.size(), 1.0f);
        this.actualDataNodes = this.isEmptyDataNodes(dataNodes) ? this.generateDataNodes(tableRuleConfig.getLogicTable(), shardingDataSourceNames.getDataSourceNames()) : this.generateDataNodes(dataNodes, shardingDataSourceNames.getDataSourceNames());
        this.databaseShardingStrategy = null == tableRuleConfig.getDatabaseShardingStrategyConfig() ? null : ShardingStrategyFactory.newInstance(tableRuleConfig.getDatabaseShardingStrategyConfig());
        this.tableShardingStrategy = null == tableRuleConfig.getTableShardingStrategyConfig() ? null : ShardingStrategyFactory.newInstance(tableRuleConfig.getTableShardingStrategyConfig());
        this.generateKeyColumn = tableRuleConfig.getKeyGeneratorColumnName();
        this.keyGenerator = tableRuleConfig.getKeyGenerator();
        this.logicIndex = null == tableRuleConfig.getLogicIndex() ? null : tableRuleConfig.getLogicIndex().toLowerCase();
    }

    private boolean isEmptyDataNodes(List<String> dataNodes) {
        return null == dataNodes || dataNodes.isEmpty();
    }

    private List<DataNode> generateDataNodes(String logicTable, Collection<String> dataSourceNames) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        int index = 0;
        for (String each : dataSourceNames) {
            DataNode dataNode = new DataNode(each, logicTable);
            result.add(dataNode);
            this.dataNodeIndexMap.put(dataNode, index);
            ++index;
        }
        return result;
    }

    private List<DataNode> generateDataNodes(List<String> actualDataNodes, Collection<String> dataSourceNames) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        int index = 0;
        for (String each : actualDataNodes) {
            DataNode dataNode = new DataNode(each);
            if (!dataSourceNames.contains(dataNode.getDataSourceName())) {
                throw new ShardingException("Cannot find data source in sharding rule, invalid actual data node is: '%s'", each);
            }
            result.add(dataNode);
            this.dataNodeIndexMap.put(dataNode, index);
            ++index;
        }
        return result;
    }

    public Map<String, List<DataNode>> getDataNodeGroups() {
        LinkedHashMap<String, List<DataNode>> result = new LinkedHashMap<String, List<DataNode>>(this.actualDataNodes.size(), 1.0f);
        for (DataNode each : this.actualDataNodes) {
            String dataSourceName = each.getDataSourceName();
            if (!result.containsKey(dataSourceName)) {
                result.put(dataSourceName, new LinkedList());
            }
            ((List)result.get(dataSourceName)).add(each);
        }
        return result;
    }

    public Collection<String> getActualDatasourceNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.actualDataNodes.size());
        for (DataNode each : this.actualDataNodes) {
            result.add(each.getDataSourceName());
        }
        return result;
    }

    public Collection<String> getActualTableNames(String targetDataSource) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.actualDataNodes.size());
        for (DataNode each : this.actualDataNodes) {
            if (!targetDataSource.equals(each.getDataSourceName())) continue;
            result.add(each.getTableName());
        }
        return result;
    }

    int findActualTableIndex(String dataSourceName, String actualTableName) {
        DataNode dataNode = new DataNode(dataSourceName, actualTableName);
        return this.dataNodeIndexMap.containsKey(dataNode) ? this.dataNodeIndexMap.get(dataNode) : -1;
    }

    boolean isExisted(String actualTableName) {
        for (DataNode each : this.actualDataNodes) {
            if (!each.getTableName().equalsIgnoreCase(actualTableName)) continue;
            return true;
        }
        return false;
    }

    public String getLogicTable() {
        return this.logicTable;
    }

    public List<DataNode> getActualDataNodes() {
        return this.actualDataNodes;
    }

    public ShardingStrategy getDatabaseShardingStrategy() {
        return this.databaseShardingStrategy;
    }

    public ShardingStrategy getTableShardingStrategy() {
        return this.tableShardingStrategy;
    }

    public String getGenerateKeyColumn() {
        return this.generateKeyColumn;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public String getLogicIndex() {
        return this.logicIndex;
    }

    public String toString() {
        return "TableRule(logicTable=" + this.getLogicTable() + ", actualDataNodes=" + this.getActualDataNodes() + ", databaseShardingStrategy=" + this.getDatabaseShardingStrategy() + ", tableShardingStrategy=" + this.getTableShardingStrategy() + ", generateKeyColumn=" + this.getGenerateKeyColumn() + ", keyGenerator=" + this.getKeyGenerator() + ", logicIndex=" + this.getLogicIndex() + ")";
    }
}

