/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.hint;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.hint.ShardingKey;
import io.shardingsphere.core.routing.strategy.hint.HintShardingStrategy;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.TableUnit;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseHintRoutingEngine
implements RoutingEngine {
    private static final Logger log = LoggerFactory.getLogger(DatabaseHintRoutingEngine.class);
    private final Collection<String> dataSourceNames;
    private final HintShardingStrategy databaseShardingStrategy;

    @Override
    public RoutingResult route() {
        Optional<ShardingValue> shardingValue = HintManagerHolder.getDatabaseShardingValue(new ShardingKey("DB_TABLE_NAME", "DB_COLUMN_NAME"));
        Preconditions.checkState((boolean)shardingValue.isPresent());
        log.debug("Before database sharding only db:{} sharding values: {}", this.dataSourceNames, shardingValue.get());
        Collection<String> routingDataSources = this.databaseShardingStrategy.doSharding(this.dataSourceNames, Collections.singletonList(shardingValue.get()));
        Preconditions.checkState((!routingDataSources.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        log.debug("After database sharding only result: {}", routingDataSources);
        RoutingResult result = new RoutingResult();
        for (String each : routingDataSources) {
            result.getTableUnits().getTableUnits().add(new TableUnit(each));
        }
        return result;
    }

    @ConstructorProperties(value={"dataSourceNames", "databaseShardingStrategy"})
    public DatabaseHintRoutingEngine(Collection<String> dataSourceNames, HintShardingStrategy databaseShardingStrategy) {
        this.dataSourceNames = dataSourceNames;
        this.databaseShardingStrategy = databaseShardingStrategy;
    }
}

