/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.broadcast;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.token.IndexToken;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.RoutingTable;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public final class TableBroadcastRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final SQLStatement sqlStatement;

    @Override
    public RoutingResult route() {
        RoutingResult result = new RoutingResult();
        for (String each : this.getLogicTableNames()) {
            result.getTableUnits().getTableUnits().addAll(this.getAllTableUnits(each));
        }
        return result;
    }

    private Collection<String> getLogicTableNames() {
        if (this.isOperateIndexWithoutTable()) {
            return Collections.singletonList(this.shardingRule.getLogicTableName(this.getIndexToken().getIndexName()));
        }
        return this.sqlStatement.getTables().getTableNames();
    }

    private boolean isOperateIndexWithoutTable() {
        return this.sqlStatement instanceof DDLStatement && this.sqlStatement.getTables().isEmpty();
    }

    private IndexToken getIndexToken() {
        Preconditions.checkState((1 == this.sqlStatement.getSqlTokens().size() ? 1 : 0) != 0);
        return (IndexToken)this.sqlStatement.getSqlTokens().get(0);
    }

    private Collection<TableUnit> getAllTableUnits(String logicTableName) {
        LinkedList<TableUnit> result = new LinkedList<TableUnit>();
        TableRule tableRule = this.shardingRule.getTableRuleByLogicTableName(logicTableName);
        for (DataNode each : tableRule.getActualDataNodes()) {
            TableUnit tableUnit = new TableUnit(each.getDataSourceName());
            tableUnit.getRoutingTables().add(new RoutingTable(logicTableName, each.getTableName()));
            result.add(tableUnit);
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "sqlStatement"})
    public TableBroadcastRoutingEngine(ShardingRule shardingRule, SQLStatement sqlStatement) {
        this.shardingRule = shardingRule;
        this.sqlStatement = sqlStatement;
    }
}

