/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rewrite;

import com.google.common.base.Strings;
import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.optimizer.condition.ShardingCondition;
import io.shardingsphere.core.optimizer.insert.InsertShardingCondition;
import io.shardingsphere.core.rewrite.placeholder.IndexPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.InsertValuesPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.SchemaPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.ShardingPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.TablePlaceholder;
import io.shardingsphere.core.routing.SQLUnit;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SQLBuilder {
    private final List<Object> segments = new LinkedList<Object>();
    private final List<Object> parameters;
    private StringBuilder currentSegment;

    public SQLBuilder() {
        this(Collections.emptyList());
    }

    public SQLBuilder(List<Object> parameters) {
        this.parameters = parameters;
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public void appendLiterals(String literals) {
        this.currentSegment.append(literals);
    }

    public void appendPlaceholder(ShardingPlaceholder shardingPlaceholder) {
        this.segments.add(shardingPlaceholder);
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public SQLUnit toSQL(TableUnit tableUnit, Map<String, String> logicAndActualTableMap, ShardingRule shardingRule, ShardingDataSourceMetaData shardingDataSourceMetaData) {
        StringBuilder result = new StringBuilder();
        LinkedList<Object> insertParameters = new LinkedList<Object>();
        for (Object each : this.segments) {
            if (!(each instanceof ShardingPlaceholder)) {
                result.append(each);
                continue;
            }
            String logicTableName = ((ShardingPlaceholder)each).getLogicTableName();
            String actualTableName = logicAndActualTableMap.get(logicTableName);
            if (each instanceof TablePlaceholder) {
                this.appendTablePlaceholder((TablePlaceholder)each, actualTableName, result);
                continue;
            }
            if (each instanceof SchemaPlaceholder) {
                this.appendSchemaPlaceholder(shardingRule, shardingDataSourceMetaData, actualTableName, result);
                continue;
            }
            if (each instanceof IndexPlaceholder) {
                this.appendIndexPlaceholder((IndexPlaceholder)each, actualTableName, result);
                continue;
            }
            if (each instanceof InsertValuesPlaceholder) {
                this.appendInsertValuesPlaceholder(tableUnit, insertParameters, (InsertValuesPlaceholder)each, result);
                continue;
            }
            result.append(each);
        }
        ArrayList<List<Object>> parameterSets = insertParameters.isEmpty() ? new ArrayList<List<Object>>(Collections.singleton(this.parameters)) : new ArrayList(Collections.singleton(insertParameters));
        return new SQLUnit(result.toString(), parameterSets);
    }

    private void appendTablePlaceholder(TablePlaceholder tablePlaceholder, String actualTableName, StringBuilder stringBuilder) {
        String logicTableName = tablePlaceholder.getLogicTableName();
        String originalLiterals = tablePlaceholder.getOriginalLiterals();
        if (logicTableName.length() == originalLiterals.length()) {
            stringBuilder.append(null == actualTableName ? logicTableName : actualTableName);
        } else {
            char delimiter = originalLiterals.charAt(0);
            stringBuilder.append(null == actualTableName ? originalLiterals : delimiter + actualTableName + delimiter);
        }
    }

    private void appendSchemaPlaceholder(ShardingRule shardingRule, ShardingDataSourceMetaData shardingDataSourceMetaData, String actualTableName, StringBuilder stringBuilder) {
        stringBuilder.append(shardingDataSourceMetaData.getActualDataSourceMetaData(shardingRule.getActualDataSourceNameByActualTableName(actualTableName)).getSchemeName());
    }

    private void appendIndexPlaceholder(IndexPlaceholder indexPlaceholder, String actualTableName, StringBuilder stringBuilder) {
        stringBuilder.append(indexPlaceholder.getLogicIndexName());
        if (!Strings.isNullOrEmpty((String)actualTableName)) {
            stringBuilder.append("_");
            stringBuilder.append(actualTableName);
        }
    }

    private void appendInsertValuesPlaceholder(TableUnit tableUnit, List<Object> parameters, InsertValuesPlaceholder insertValuesPlaceholder, StringBuilder stringBuilder) {
        LinkedList<String> expressions = new LinkedList<String>();
        for (ShardingCondition each : insertValuesPlaceholder.getShardingConditions().getShardingConditions()) {
            this.processInsertShardingCondition(tableUnit, (InsertShardingCondition)each, expressions, parameters);
        }
        int count = 0;
        for (String each : expressions) {
            if (0 != count) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(each);
            ++count;
        }
    }

    private void processInsertShardingCondition(TableUnit tableUnit, InsertShardingCondition shardingCondition, List<String> expressions, List<Object> parameters) {
        for (DataNode each : shardingCondition.getDataNodes()) {
            if (!each.getDataSourceName().equals(tableUnit.getDataSourceName()) || !each.getTableName().equals(tableUnit.getRoutingTables().iterator().next().getActualTableName())) continue;
            expressions.add(shardingCondition.getInsertValueExpression());
            parameters.addAll(shardingCondition.getParameters());
            return;
        }
    }
}

