/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.create.index;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Token;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.token.IndexToken;
import io.shardingsphere.core.rule.ShardingRule;

public abstract class AbstractCreateIndexParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public AbstractCreateIndexParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public final DDLStatement parse() {
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateIndexAndKeyword());
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateAndKeyword());
        DDLStatement result = new DDLStatement();
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.INDEX)) {
            throw new SQLParsingException("Can't support other CREATE grammar unless CREATE INDEX.", new Object[0]);
        }
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateIndexAndIndexName());
        this.parseIndex(result);
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        return result;
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateIndexAndKeyword();

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateAndKeyword();

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateIndexAndIndexName();

    private void parseIndex(DDLStatement ddlStatement) {
        Token currentToken = this.lexerEngine.getCurrentToken();
        int beginPosition = currentToken.getEndPosition() - currentToken.getLiterals().length();
        String literals = currentToken.getLiterals();
        this.lexerEngine.skipUntil(DefaultKeyword.ON);
        this.lexerEngine.nextToken();
        String tableName = this.lexerEngine.getCurrentToken().getLiterals();
        ddlStatement.getSqlTokens().add(new IndexToken(beginPosition, literals, tableName));
    }

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected TableReferencesClauseParser getTableReferencesClauseParser() {
        return this.tableReferencesClauseParser;
    }
}

