/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.mysql.sql;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowColumnsStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowCreateTableStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowDatabasesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowIndexStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowOtherStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTableStatusStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTablesStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.show.AbstractShowParser;
import io.shardingsphere.core.parsing.parser.token.RemoveToken;
import io.shardingsphere.core.parsing.parser.token.SchemaToken;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;

public final class MySQLShowParser
extends AbstractShowParser {
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public MySQLShowParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public DALStatement parse() {
        this.lexerEngine.nextToken();
        this.lexerEngine.skipIfEqual(DefaultKeyword.FULL);
        if (this.lexerEngine.equalAny(MySQLKeyword.DATABASES)) {
            return this.showDatabases();
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE, MySQLKeyword.STATUS)) {
            return this.parseShowTableStatus();
        }
        if (this.lexerEngine.skipIfEqual(MySQLKeyword.TABLES)) {
            return this.parseShowTables();
        }
        if (this.lexerEngine.skipIfEqual(MySQLKeyword.COLUMNS, MySQLKeyword.FIELDS)) {
            return this.parseShowColumnsFields();
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.CREATE) && this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE)) {
            return this.parseShowCreateTable();
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.INDEX, MySQLKeyword.INDEXES, MySQLKeyword.KEYS)) {
            return this.parseShowIndex();
        }
        return new ShowOtherStatement();
    }

    private DALStatement showDatabases() {
        return new ShowDatabasesStatement();
    }

    private DALStatement parseShowTableStatus() {
        return new ShowTableStatusStatement();
    }

    private DALStatement parseShowTables() {
        ShowTablesStatement result = new ShowTablesStatement();
        if (this.lexerEngine.equalAny(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            this.lexerEngine.nextToken();
            this.lexerEngine.nextToken();
            result.getSqlTokens().add(new RemoveToken(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition()));
        }
        return result;
    }

    private DALStatement parseShowColumnsFields() {
        ShowColumnsStatement result = new ShowColumnsStatement();
        this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            result.getSqlTokens().add(new SchemaToken(beginPosition, this.lexerEngine.getCurrentToken().getLiterals(), result.getTables().getSingleTableName()));
        }
        return result;
    }

    private DALStatement parseShowCreateTable() {
        ShowCreateTableStatement result = new ShowCreateTableStatement();
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        return result;
    }

    private DALStatement parseShowIndex() {
        ShowIndexStatement result = new ShowIndexStatement();
        this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            result.getSqlTokens().add(new SchemaToken(beginPosition, this.lexerEngine.getCurrentToken().getLiterals(), result.getTables().getSingleTableName()));
        }
        return result;
    }

    @ConstructorProperties(value={"lexerEngine", "tableReferencesClauseParser"})
    public MySQLShowParser(LexerEngine lexerEngine, TableReferencesClauseParser tableReferencesClauseParser) {
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = tableReferencesClauseParser;
    }
}

