/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.optimizer.insert;

import com.google.common.base.Optional;
import io.shardingsphere.core.api.algorithm.sharding.ListShardingValue;
import io.shardingsphere.core.optimizer.OptimizeEngine;
import io.shardingsphere.core.optimizer.condition.ShardingCondition;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.optimizer.insert.InsertShardingCondition;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.parser.context.condition.AndCondition;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.Condition;
import io.shardingsphere.core.parsing.parser.context.condition.GeneratedKeyCondition;
import io.shardingsphere.core.parsing.parser.context.insertvalue.InsertValue;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class InsertOptimizeEngine
implements OptimizeEngine {
    private final ShardingRule shardingRule;
    private final InsertStatement insertStatement;
    private final List<Object> parameters;
    private final GeneratedKey generatedKey;

    @Override
    public ShardingConditions optimize() {
        List<AndCondition> andConditions = this.insertStatement.getConditions().getOrCondition().getAndConditions();
        List<InsertValue> insertValues = this.insertStatement.getInsertValues().getInsertValues();
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>(andConditions.size());
        Iterator<Number> generatedKeys = null;
        int count = 0;
        int parametersCount = 0;
        for (AndCondition each : andConditions) {
            InsertShardingCondition insertShardingCondition;
            InsertValue insertValue = insertValues.get(count);
            ArrayList<Object> currentParameters = new ArrayList<Object>(insertValue.getParametersCount() + 1);
            if (insertValue.getParametersCount() > 0) {
                currentParameters.addAll(this.parameters.subList(parametersCount, parametersCount += insertValue.getParametersCount()));
            }
            String logicTableName = this.insertStatement.getTables().getSingleTableName();
            Optional<Column> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(logicTableName);
            if (-1 != this.insertStatement.getGenerateKeyColumnIndex() || !generateKeyColumn.isPresent()) {
                insertShardingCondition = new InsertShardingCondition(insertValue.getExpression(), currentParameters);
            } else {
                String expression;
                if (null == generatedKeys) {
                    generatedKeys = this.generatedKey.getGeneratedKeys().iterator();
                }
                Number currentGeneratedKey = (Number)generatedKeys.next();
                if (0 == this.parameters.size()) {
                    expression = DefaultKeyword.VALUES.equals(insertValue.getType()) ? insertValue.getExpression().substring(0, insertValue.getExpression().lastIndexOf(")")) + ", " + currentGeneratedKey.toString() + ")" : ((Column)generateKeyColumn.get()).getName() + " = " + currentGeneratedKey + ", " + insertValue.getExpression();
                } else if (DefaultKeyword.VALUES.equals(insertValue.getType())) {
                    expression = insertValue.getExpression().substring(0, insertValue.getExpression().lastIndexOf(")")) + ", ?)";
                    currentParameters.add(currentGeneratedKey);
                } else {
                    expression = ((Column)generateKeyColumn.get()).getName() + " = ?, " + insertValue.getExpression();
                    currentParameters.add(0, currentGeneratedKey);
                }
                insertShardingCondition = new InsertShardingCondition(expression, currentParameters);
                insertShardingCondition.getShardingValues().add(this.getShardingCondition((Column)generateKeyColumn.get(), currentGeneratedKey));
            }
            insertShardingCondition.getShardingValues().addAll(this.getShardingCondition(each));
            result.add(insertShardingCondition);
            ++count;
        }
        return new ShardingConditions(result);
    }

    private ListShardingValue getShardingCondition(Column column, Number value) {
        return new ListShardingValue(column.getTableName(), column.getName(), new GeneratedKeyCondition(column, -1, value).getConditionValues(this.parameters));
    }

    private Collection<ListShardingValue> getShardingCondition(AndCondition andCondition) {
        LinkedList<ListShardingValue> result = new LinkedList<ListShardingValue>();
        for (Condition each : andCondition.getConditions()) {
            result.add(new ListShardingValue(each.getColumn().getTableName(), each.getColumn().getName(), each.getConditionValues(this.parameters)));
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "insertStatement", "parameters", "generatedKey"})
    public InsertOptimizeEngine(ShardingRule shardingRule, InsertStatement insertStatement, List<Object> parameters, GeneratedKey generatedKey) {
        this.shardingRule = shardingRule;
        this.insertStatement = insertStatement;
        this.parameters = parameters;
        this.generatedKey = generatedKey;
    }
}

