/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.prepare;

import com.google.common.collect.Lists;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.sql.SQLExecuteUnit;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareCallback;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLUnit;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SQLExecutePrepareTemplate {
    private final int maxConnectionsSizePerQuery;

    public Collection<ShardingExecuteGroup<SQLExecuteUnit>> getExecuteUnitGroups(Collection<RouteUnit> routeUnits, SQLExecutePrepareCallback callback) throws SQLException {
        Map<String, List<SQLUnit>> sqlUnitGroups = this.getSQLUnitGroups(routeUnits);
        LinkedList<ShardingExecuteGroup<SQLExecuteUnit>> result = new LinkedList<ShardingExecuteGroup<SQLExecuteUnit>>();
        for (Map.Entry<String, List<SQLUnit>> entry : sqlUnitGroups.entrySet()) {
            result.addAll(this.getSQLExecuteGroups(entry.getKey(), entry.getValue(), callback));
        }
        return result;
    }

    private Map<String, List<SQLUnit>> getSQLUnitGroups(Collection<RouteUnit> routeUnits) {
        LinkedHashMap<String, List<SQLUnit>> result = new LinkedHashMap<String, List<SQLUnit>>(routeUnits.size(), 1.0f);
        for (RouteUnit each : routeUnits) {
            if (!result.containsKey(each.getDataSourceName())) {
                result.put(each.getDataSourceName(), new LinkedList());
            }
            ((List)result.get(each.getDataSourceName())).add(each.getSqlUnit());
        }
        return result;
    }

    private List<ShardingExecuteGroup<SQLExecuteUnit>> getSQLExecuteGroups(String dataSourceName, List<SQLUnit> sqlUnits, SQLExecutePrepareCallback callback) throws SQLException {
        LinkedList<ShardingExecuteGroup<SQLExecuteUnit>> result = new LinkedList<ShardingExecuteGroup<SQLExecuteUnit>>();
        int desiredPartitionSize = Math.max(sqlUnits.size() / this.maxConnectionsSizePerQuery, 1);
        for (List each : Lists.partition(sqlUnits, (int)desiredPartitionSize)) {
            result.add(this.getSQLExecuteGroup(callback.getConnection(dataSourceName), dataSourceName, each, callback));
        }
        return result;
    }

    private ShardingExecuteGroup<SQLExecuteUnit> getSQLExecuteGroup(Connection connection, String dataSourceName, List<SQLUnit> sqlUnitGroup, SQLExecutePrepareCallback callback) throws SQLException {
        LinkedList<SQLExecuteUnit> result = new LinkedList<SQLExecuteUnit>();
        for (SQLUnit each : sqlUnitGroup) {
            result.add(callback.createSQLExecuteUnit(connection, new RouteUnit(dataSourceName, each)));
        }
        return new ShardingExecuteGroup<SQLExecuteUnit>(result);
    }

    @ConstructorProperties(value={"maxConnectionsSizePerQuery"})
    public SQLExecutePrepareTemplate(int maxConnectionsSizePerQuery) {
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
    }
}

